package com.mdlc.bettergamemodeswitcher.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.mdlc.bettergamemodeswitcher.GameModeConfiguration;
import net.minecraft.class_1934;
import net.minecraft.class_310;
import net.minecraft.class_5289;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;


@Mixin(class_5289.class)
public abstract class GameModeSwitcherScreenMixin {
    /**
     * Redirects the {@link net.minecraft.class_1657#method_64475(int) hasPermissions} call in F3+N
     * behavior to check whether the {@code gamemode} command is available instead.
     */
    @Redirect(method = "switchToHoveredGameMode(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/gui/screens/debug/GameModeSwitcherScreen$GameModeIcon;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;hasPermissions(I)Z", ordinal = 0))
    private static boolean redirectF3NHasPermission(class_746 player, int level, @Local(argsOnly = true) class_310 minecraft) {
        return GameModeConfiguration.hasPermission(minecraft);
    }

    /**
     * Changes the default selected game mode to ignore Spectator.
     */
    @Inject(method = "getDefaultSelected", at = @At("HEAD"), cancellable = true)
    private void changeDefaultSelected(CallbackInfoReturnable<class_1934> cir) {
        cir.setReturnValue(GameModeConfiguration.getSwitcherDefaultSelection(class_310.method_1551().field_1761));
    }
}
