package com.mdlc.bettergamemodeswitcher.mixin;

import com.mdlc.bettergamemodeswitcher.GameModeConfiguration;
import net.minecraft.class_309;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;


@Mixin(class_309.class)
public abstract class KeyboardHandlerMixin {
    @Shadow @Final private class_310 minecraft;

    /**
     * Redirects the {@link net.minecraft.class_1657#method_64475(int) hasPermissions} call in F3+N
     * behavior to check whether the {@code gamemode} command is available instead.
     */
    @Redirect(method = "handleDebugKeys", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;hasPermissions(I)Z", ordinal = 1))
    private boolean redirectF3NHasPermission(class_746 player, int level) {
        return GameModeConfiguration.hasPermission(this.minecraft);
    }

    /**
     * Redirects the {@link net.minecraft.class_1657#method_64475(int) hasPermissions} call in the
     * game mode switcher's behavior to check whether the {@code gamemode} command is available instead.
     */
    @Redirect(method = "handleDebugKeys", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/player/LocalPlayer;hasPermissions(I)Z", ordinal = 2))
    private boolean redirectF3F4HasPermission(class_746 player, int level) {
        return GameModeConfiguration.hasPermission(this.minecraft);
    }
}
