package io.github.ennuil.ok_zoomer.config.screen.components;

import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8012;

public class OkZoomerSelectionList extends class_4265<OkZoomerSelectionList.Entry> {
	private final class_437 screen;

	public OkZoomerSelectionList(class_310 minecraft, int width, int height, int y, class_437 screen) {
		super(minecraft, width, height, y, 25);
		this.screen = screen;
	}

	@Override
	public int method_25322() {
		return 310;
	}

	public void addCategory(class_2561 component) {
		this.method_25321(new CategoryEntry(component, this.screen));
	}

	public void addButton(class_339 button) {
		this.method_25321(new ButtonEntry(button, this.screen));
	}

	public void addButton(class_339 leftButton, class_339 rightButton) {
		this.method_25321(new ButtonEntry(leftButton, rightButton, this.screen));
	}

	public abstract static class Entry extends class_4265.class_4266<Entry> {
		final class_437 screen;

		Entry(class_437 screen) {
			this.screen = screen;
		}
	}

	static class CategoryEntry extends Entry {
		private final class_2561 title;

		private CategoryEntry(class_2561 title, class_437 screen) {
			super(screen);
			this.title = title;
		}

		@Override
		public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
			int x = this.screen.field_22789 / 2 - 155;
			int y = this.method_73382();
			int rowWidth = 310;

			graphics.method_25294(x, y + 1, x + rowWidth, y + 19, 0xA0000000);
			graphics.method_27534(this.screen.method_64506(), this.title, x + rowWidth / 2, y + 6, class_8012.field_42973);
		}

		@Override
		public int method_25364() {
			return 20;
		}

		@Override
		public @NotNull List<? extends class_364> method_25396() {
			return List.of();
		}

		@Override
		public @NotNull List<? extends class_6379> method_37025() {
			return List.of(new class_6379() {
				@Override
				public @NotNull class_6380 method_37018() {
					return class_6380.field_33785;
				}

				@Override
				public void method_37020(class_6382 narrationElementOutput) {
					narrationElementOutput.method_37034(class_6381.field_33788, CategoryEntry.this.title);
				}
			});
		}
	}

	static class ButtonEntry extends Entry {
		private final class_339 leftButton;
		private final class_339 rightButton;
		private final int entryHeight;
		private final List<class_339> buttons;

		public ButtonEntry(class_339 button, class_437 screen) {
			super(screen);
			button.method_25358(310);
			this.leftButton = button;
			this.rightButton = null;
			this.entryHeight = button.method_25364() + 4;
			this.buttons = List.of(button);
		}

		public ButtonEntry(class_339 leftButton, class_339 rightButton, class_437 screen) {
			super(screen);
			this.leftButton = leftButton;
			this.rightButton = rightButton;
			this.entryHeight = (rightButton != null ? Math.max(leftButton.method_25364(), rightButton.method_25364()) : leftButton.method_25364()) + 4;
			this.buttons = rightButton != null ? List.of(leftButton, rightButton) : List.of(leftButton);
		}

		@Override
		public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
			int x = this.screen.field_22789 / 2 - 155;
			int y = this.method_73382();
			int rowWidth = 310;

			this.leftButton.method_48229(x, y + 2);
			this.leftButton.method_25394(graphics, mouseX, mouseY, partialTick);

			if (this.rightButton != null) {
				this.rightButton.method_48229(x + 160, y + 2);
				this.rightButton.method_25394(graphics, mouseX, mouseY, partialTick);
			}
		}

		// Yes, I don't exactly like this either, but this allows for gaps of 5 pixels as well as a nice bottom padding
		// against the end of the page
		// (This used to be a hardcoded reference to 24)
		@Override
		public int method_25364() {
			return this.entryHeight;
		}

		@Override
		public @NotNull List<? extends class_364> method_25396() {
			return this.buttons;
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return this.buttons;
		}
	}
}
