package io.github.ennuil.ok_zoomer.key_binds;

import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.utils.ModUtils;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

// Manages the zoom key binds themselves
public class ZoomKeyBinds {
	// TODO - Bleh, immutability; I have a plan
	private static final boolean ENABLE_EXTRA_KEY_BINDS = OkZoomerConfigManager.CONFIG.features.extraKeyBinds.getRealValue();

	// The "Zoom" category
	public static final class_304.class_11900 ZOOM_CATEGORY = class_304.class_11900.method_74698(ModUtils.id("zoom"));

	// The zoom key bind, which will be registered
	public static final class_304 ZOOM_KEY = new class_304("key.ok_zoomer.zoom", GLFW.GLFW_KEY_C, ZOOM_CATEGORY);

	// The "Decrease Zoom" key bind
	public static final class_304 DECREASE_ZOOM_KEY = getExtraKeyBind("key.ok_zoomer.decrease_zoom");

	// The "Increase Zoom" key bind
	public static final class_304 INCREASE_ZOOM_KEY = getExtraKeyBind("key.ok_zoomer.increase_zoom");

	// The "Reset Zoom" key bind
	public static final class_304 RESET_ZOOM_KEY = getExtraKeyBind("key.ok_zoomer.reset_zoom");

	// The method used to check if the zoom manipulation key binds should be disabled, can be used by other mods.
	public static boolean areExtraKeyBindsEnabled() {
		return ZoomKeyBinds.ENABLE_EXTRA_KEY_BINDS;
	}

	// The method used to get the extra keybinds, if disabled, return null.
	public static class_304 getExtraKeyBind(String translationKey) {
		if (ZoomKeyBinds.areExtraKeyBindsEnabled()) {
			return new class_304(translationKey, class_3675.field_16237.method_1444(), ZOOM_CATEGORY);
		}

		return null;
	}
}
