package io.github.ennuil.ok_zoomer.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.ConfigEnums.ZoomModes;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.key_binds.ZoomKeyBinds;
import io.github.ennuil.ok_zoomer.utils.ZoomUtils;
import io.github.ennuil.ok_zoomer.zoom.Zoom;
import net.minecraft.class_11910;
import net.minecraft.class_312;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

// This mixin is responsible for the mouse-behavior-changing part of the zoom
@Mixin(class_312.class)
public abstract class MouseHandlerMixin {
	@Inject(
		method = "onScroll",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/player/LocalPlayer;isSpectator()Z"
		),
		cancellable = true
	)
	private void zoomScrollOnScroll(CallbackInfo ci, @Local int i) {
		if (i != 0) {
			if (OkZoomerConfigManager.CONFIG.features.zoomScrolling.value()) {
				if (OkZoomerConfigManager.CONFIG.features.zoomMode.value().equals(ConfigEnums.ZoomModes.PERSISTENT)) {
					if (!ZoomKeyBinds.ZOOM_KEY.method_1434()) return;
				}

				if (Zoom.isZooming()) {
					ZoomUtils.changeZoomDivisor(i > 0);
					ci.cancel();
				}
			}
		}
	}

	// Handles the zoom scrolling reset through the middle button
	@Inject(
		method = "onButton",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/KeyMapping;set(Lcom/mojang/blaze3d/platform/InputConstants$Key;Z)V"
		),
		cancellable = true
	)
	private void zoomerOnMouseButton(long window, class_11910 buttonInfo, int action, CallbackInfo ci) {
		if (OkZoomerConfigManager.CONFIG.features.zoomScrolling.value()) {
			if (OkZoomerConfigManager.CONFIG.features.zoomMode.value() == ZoomModes.PERSISTENT && !ZoomKeyBinds.ZOOM_KEY.method_1434()) {
				return;
			}

			if (buttonInfo.comp_4801() == GLFW.GLFW_MOUSE_BUTTON_MIDDLE && action == GLFW.GLFW_PRESS && Zoom.isZooming()) {
				if (OkZoomerConfigManager.CONFIG.tweaks.resetZoomWithMouse.value()) {
					ZoomUtils.resetZoomDivisor(true);
					ci.cancel();
				}
			}
		}
	}

	// Prevents the spyglass from working if zooming replaces its zoom
	@ModifyExpressionValue(
		method = "turnPlayer",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/player/LocalPlayer;isScoping()Z"
		)
	)
	private boolean replaceSpyglassMouseMovement(boolean isScoping) {
		if (switch (OkZoomerConfigManager.CONFIG.features.spyglassMode.value()) {
			case REPLACE_ZOOM, BOTH -> true;
			default -> false;
		}) {
			return false;
		}

		return isScoping;
	}
}
