package io.github.ennuil.ok_zoomer.mixin.common.fade;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.textures.GpuTextureView;
import io.github.ennuil.ok_zoomer.utils.ZoomUtils;
import net.minecraft.class_332;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(class_332.class)
public abstract class GuiGraphicsMixin {
	@WrapMethod(method = "submitBlit")
	private void modifyFade(RenderPipeline pipeline, GpuTextureView atlasTexture, int x0, int y0, int x1, int y1, float u0, float u1, float v0, float v1, int color, Operation<Void> original) {
		if (ZoomUtils.getFadeModifier() != null) {
			float fade = ZoomUtils.getFadeModifier();
			if (pipeline.getBlendFunction().isPresent() && pipeline.getBlendFunction().get().destAlpha() == DestFactor.ZERO) {
				original.call(pipeline, atlasTexture, x0, y0, x1, y1, u0, u1, v0, v1, class_9848.method_61321(color, fade));
			} else {
				original.call(pipeline, atlasTexture, x0, y0, x1, y1, u0, u1, v0, v1, class_9848.method_71346(fade, color));
			}
		} else {
			original.call(pipeline, atlasTexture, x0, y0, x1, y1, u0, u1, v0, v1, color);
		}
	}
}
