package io.github.ennuil.ok_zoomer.mixin.common.key_binds;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.config.screen.OkZoomerConfigScreen;
import io.github.ennuil.ok_zoomer.utils.ModUtils;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_4185;
import net.minecraft.class_459;
import net.minecraft.class_8666;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_459.class_462.class)
public abstract class KeyEntryMixin extends class_459.class_461 {
	@Unique
	private static final class_8666 SETTINGS_BUTTON_SPRITE = new class_8666(
		ModUtils.id("key_binds/settings"),
		ModUtils.id("key_binds/settings_selected")
	);

	@Unique
	private class_4185 settingsButton;

	@Shadow(remap = false, aliases = "this$0")
	@Final
	class_459 field_2742;

	@Shadow
	@Final
	private class_4185 changeButton;

	@Shadow
	@Final
	private class_2561 name;

	@Inject(method = "<init>", at = @At("TAIL"))
	private void initSettingsButton(class_459 keyBindsList, class_304 key, class_2561 name, CallbackInfo ci) {
		if (key.method_1431().equals("key.ok_zoomer.zoom") && OkZoomerConfigManager.CONFIG.tweaks.showSettingsOnKey.value()) {
			this.settingsButton = new class_344(
				0, 0, 20, 20,
				SETTINGS_BUTTON_SPRITE,
				button -> ((AbstractSelectionListAccessor) field_2742).getMinecraft().method_1507(
					new OkZoomerConfigScreen(((KeyBindsListAccessor) field_2742).getKeyBindsScreen())
				),
				class_2561.method_43469("key.ok_zoomer.settings", this.name));
		}
	}

	@Inject(method = "renderContent", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;III)V"))
	private void renderSettingsButton(class_332 graphics, int mouseX, int mouseY, boolean bl, float partialTick, CallbackInfo ci) {
		if (this.settingsButton != null) {
			this.settingsButton.method_48229(this.changeButton.method_46426() - 25, this.method_73382() - 2);
			this.settingsButton.method_25394(graphics, mouseX, mouseY, partialTick);
		}
	}

	@WrapOperation(method = { "children", "narratables" }, at = @At(value = "INVOKE", target = "Lcom/google/common/collect/ImmutableList;of(Ljava/lang/Object;Ljava/lang/Object;)Lcom/google/common/collect/ImmutableList;"))
	private ImmutableList<?> addSettingsButtonToLists(Object e1, Object e2, Operation<ImmutableList<?>> original) {
		if (this.settingsButton != null) {
			return ImmutableList.of(this.settingsButton, e1, e2);
		} else {
			return original.call(e1, e2);
		}
	}
}
