package io.github.ennuil.ok_zoomer.utils;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.class_3414;

public class Portals {
	public static class_3414 getZoomInSound() {
		return getFromPortal("getZoomInSound");
	}

	public static class_3414 getZoomOutSound() {
		return getFromPortal("getZoomOutSound");
	}

	public static class_3414 getScrollSound() {
		return getFromPortal("getScrollSound");
	}

	public static <T> T getFromPortal(String method) {
		try {
			var fabricClass = getClass("io.github.ennuil.ok_zoomer.utils.FabricPortals");
			if (fabricClass != null) {
				return (T) fabricClass.getMethod(method).invoke(null);
			} else {
				var norgeClass = getClass("io.github.ennuil.ok_zoomer.utils.NorgePortals");
				if (norgeClass != null) {
					return (T) norgeClass.getMethod(method).invoke(null);
				}
			}

			return null;
		} catch (NoSuchMethodException | InvocationTargetException | IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}

	private static Class<?> getClass(String className) {
		try {
			return Class.forName(className);
		} catch (ClassNotFoundException e) {
			return null;
		}
	}
}
