package io.github.ennuil.ok_zoomer.zoom.modifiers;

import net.minecraft.class_310;
import net.minecraft.class_3540;

/**
 * An implemenation of Vanilla's Cinematic Camera as a mouse modifier.
 */
public class CinematicCameraMouseModifier implements MouseModifier {
	private boolean active;
	private class_310 minecraft;
	private boolean cinematicCameraEnabled;
	private final class_3540 cursorXZoomSmoother = new class_3540();
	private final class_3540 cursorYZoomSmoother = new class_3540();

	/**
	 * Initializes an instance of the cinematic camera mouse modifier.
	*/
	public CinematicCameraMouseModifier() {
		this.active = false;
		this.ensureClient();
	}

	@Override
	public boolean getActive() {
		return this.active;
	}

	@Override
	public double applyXModifier(double cursorDeltaX, double cursorSensitivity, double mouseUpdateTimeDelta, double targetDivisor, double transitionMultiplier) {
		if (this.cinematicCameraEnabled) {
			this.cursorXZoomSmoother.method_15428();
			return cursorDeltaX;
		}

		return this.cursorXZoomSmoother.method_15429(cursorDeltaX, mouseUpdateTimeDelta * cursorSensitivity);
	}

	@Override
	public double applyYModifier(double cursorDeltaY, double cursorSensitivity, double mouseUpdateTimeDelta, double targetDivisor, double transitionMultiplier) {
		if (this.cinematicCameraEnabled) {
			this.cursorYZoomSmoother.method_15428();
			return cursorDeltaY;
		}

		return this.cursorYZoomSmoother.method_15429(cursorDeltaY, mouseUpdateTimeDelta * cursorSensitivity);
	}

	@Override
	public void tick(boolean active) {
		this.ensureClient();
		this.cinematicCameraEnabled = this.minecraft.field_1690.field_1914;
		if (!active && this.active) {
			this.cursorXZoomSmoother.method_15428();
			this.cursorYZoomSmoother.method_15428();
		}
		this.active = active;
	}

	private void ensureClient() {
		if (this.minecraft == null) {
			this.minecraft = class_310.method_1551();
		}
	}
}
