package io.github.ennuil.ok_zoomer.zoom.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.ennuil.ok_zoomer.zoom.transitions.TransitionMode;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8012;
import net.minecraft.class_9779;

// An implementation of the spyglass overlay as a zoom overlay
public class SpyglassZoomOverlay implements ZoomOverlay {
	private final class_2960 textureId;
	//private Minecraft minecraft;
	private float scale;
	private boolean active;

	public SpyglassZoomOverlay(class_2960 textureId) {
		this.textureId = textureId;
		this.scale = 0.5F;
		this.active = false;
		//this.minecraft = Minecraft.getInstance();
	}

	@Override
	public boolean getActive() {
		return this.active;
	}

	@Override
	public boolean cancelOverlayRendering() {
		return true;
	}

	// TODO - Consider whenever a third-person view block tweak option is desirable
	@Override
	public void renderOverlay(class_332 graphics, class_9779 deltaTracker, TransitionMode transitionMode) {
		int guiWidth = graphics.method_51421();
		int guiHeight = graphics.method_51443();
		float smallerLength = (float) Math.min(guiWidth, guiHeight);
		float scaledSmallerLength = Math.min((float) guiWidth / smallerLength, (float) guiHeight / smallerLength) * scale;
		int width = class_3532.method_15375(smallerLength * scaledSmallerLength);
		int height = class_3532.method_15375(smallerLength * scaledSmallerLength);
		int x = (guiWidth - width) / 2;
		int y = (guiHeight - height) / 2;
		int borderX = x + width;
		int borderY = y + height;
		RenderSystem.enableBlend();
		graphics.method_25290(textureId, x, y, 0.0F, 0.0F, width, height, width, height);
		RenderSystem.disableBlend();
		graphics.method_48196(class_1921.method_51785(), 0, borderY, guiWidth, guiHeight, -90, class_8012.field_42974);
		graphics.method_48196(class_1921.method_51785(), 0, 0, guiWidth, y, -90, class_8012.field_42974);
		graphics.method_48196(class_1921.method_51785(), 0, y, x, borderY, -90, class_8012.field_42974);
		graphics.method_48196(class_1921.method_51785(), borderX, y, guiWidth, borderY, -90, class_8012.field_42974);
	}

	@Override
	public void tick(boolean active, double divisor, TransitionMode transitionMode) {
		this.active = active;
	}

	@Override
	public void tickBeforeRender(class_9779 deltaTracker) {
		if (!this.active) {
			this.scale = 0.5F;
		} else {
			this.scale = class_3532.method_16439(0.5F * deltaTracker.method_60636(), this.scale, 1.125F);
		}
	}
}
