package io.github.ennuil.ok_zoomer.zoom.overlays;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.ennuil.ok_zoomer.zoom.transitions.TransitionMode;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_9779;

// Implements the zoom overlay
public class ZoomerZoomOverlay implements ZoomOverlay {
	private final class_2960 textureId;
	private boolean active;

	public ZoomerZoomOverlay(class_2960 textureId) {
		this.textureId = textureId;
		this.active = false;
	}

	@Override
	public boolean getActive() {
		return this.active;
	}

	@Override
	public void renderOverlay(class_332 graphics, class_9779 deltaTracker, TransitionMode transitionMode) {
		RenderSystem.disableDepthTest();
		RenderSystem.depthMask(false);
		RenderSystem.enableBlend();
		RenderSystem.blendFuncSeparate(GlStateManager.class_4535.ZERO, GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, GlStateManager.class_4535.ONE, GlStateManager.class_4534.ZERO);
		float fade = transitionMode.getFade(deltaTracker.method_60637(true));
		RenderSystem.setShaderColor(fade, fade, fade, 1.0F);
		graphics.method_25291(this.textureId, 0, 0, -90, 0.0F, 0.0F, graphics.method_51421(), graphics.method_51443(), graphics.method_51421(), graphics.method_51443());
		RenderSystem.depthMask(true);
		RenderSystem.enableDepthTest();
		RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
		RenderSystem.defaultBlendFunc();
		RenderSystem.disableBlend();
	}

	@Override
	public void tick(boolean active, double divisor, TransitionMode transitionMode) {
		if (active || !transitionMode.getActive()) {
			this.active = active;
		}
	}
}
