package io.github.ennuil.ok_zoomer.config.screen;

import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.config.metadata.WidgetSize;
import io.github.ennuil.ok_zoomer.config.screen.components.LabelledEditBox;
import io.github.ennuil.ok_zoomer.config.screen.components.OkZoomerSelectionList;
import io.github.ennuil.ok_zoomer.utils.ModUtils;
import io.github.ennuil.ok_zoomer.utils.ZoomUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import org.quiltmc.config.api.Configs;
import org.quiltmc.config.api.Constraint;
import org.quiltmc.config.api.values.TrackedValue;
import org.quiltmc.config.api.values.ValueTreeNode;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import net.minecraft.class_8012;
import net.minecraft.class_8132;
import net.minecraft.class_8667;

// TODO - You may have dropped your silly data-driven config screen idea, but you still want to streamline the config screen. Do Config v2!
public class OkZoomerConfigScreen extends class_437 {
	private final class_2960 configId;
	private final class_437 parent;
	private ConfigTextUtils configTextUtils;
	private final class_8132 layout = new class_8132(this);
	private OkZoomerSelectionList selectionList;

	private final Map<TrackedValue<Object>, Object> newValues;
	private final Set<TrackedValue<Object>> invalidValues;
	private class_339 buttonBuffer = null;

	public OkZoomerConfigScreen(class_437 parent) {
		super(ConfigTextUtils.getConfigTitle(ModUtils.id("config")));
		this.configId = ModUtils.id("config");
		this.parent = parent;
		this.newValues = new Reference2ObjectArrayMap<>();
		this.invalidValues = new ObjectArraySet<>();
	}

	@Override
	protected void method_25426() {
		var config = Configs.getConfig(this.configId.method_12836(), this.configId.method_12832());
		this.configTextUtils = new ConfigTextUtils(config);
		this.selectionList = new OkZoomerSelectionList(this.field_22787, this.field_22789, this.field_22790 - 64, 32);

		this.selectionList.addCategory(class_2561.method_43471("config.ok_zoomer.presets"));
		var presetButton = class_5676.<ConfigEnums.ZoomPresets>method_32606(value -> class_2561.method_43471(String.format("config.ok_zoomer.presets.preset.%s", value.toString().toLowerCase(Locale.ROOT))))
			.method_32624(ConfigEnums.ZoomPresets.values())
			.method_32618(value -> class_7919.method_47407(class_2561.method_43471(String.format("config.ok_zoomer.presets.preset.%s.tooltip", value.toString().toLowerCase(Locale.ROOT)))))
			.method_32619(ConfigEnums.ZoomPresets.CAMERA)
			.method_35723(0, 0, 150, 20,
				class_2561.method_43471("config.ok_zoomer.presets.preset"));
		var resetButton = class_4185.method_46430(
				class_2561.method_43471("config.ok_zoomer.presets.apply_preset"),
				button -> this.resetToPreset(presetButton.method_32603()))
			.method_46436(class_7919.method_47407(class_2561.method_43471("config.ok_zoomer.presets.apply_preset.tooltip")))
			.method_46431();
		this.selectionList.addButton(presetButton, resetButton);

		for (var node : config.nodes()) {
			if (node instanceof ValueTreeNode.Section section) {
				this.selectionList.addCategory(this.configTextUtils.getCategoryText(section.key().toString()));

				for (var subNode : section) {
					var size = subNode.metadata(WidgetSize.TYPE);

					if (subNode instanceof TrackedValue<?> trackedValue) {
						var trackie = (TrackedValue<Object>) trackedValue;
						this.newValues.putIfAbsent(trackie, trackedValue.getRealValue());

						if (trackedValue.value() instanceof Boolean) {
							class_339 button;
							if (!trackedValue.equals(OkZoomerConfigManager.CONFIG.tweaks.unbindConflictingKey)) {
								button = class_5676.method_32613((Boolean) this.newValues.get(trackie))
									.method_32618(value -> class_7919.method_47407(this.configTextUtils.getOptionTextTooltip(trackedValue)))
									.method_32617(
										0, 0, 150, 20,
										this.configTextUtils.getOptionText(trackedValue),
										(button_, value) -> this.newValues.replace(trackie, value));
							} else {
								// TODO - ew, hardcoding; we can do better than that
								button = class_4185.method_46430(
										class_2561.method_43471("config.ok_zoomer.tweaks.unbind_conflicting_key"),
										button_ -> ZoomUtils.unbindConflictingKey(this.field_22787, true))
									.method_46436(class_7919.method_47407(class_2561.method_43471("config.ok_zoomer.tweaks.unbind_conflicting_key.tooltip")))
									.method_46431();
							}
							this.addOptionToList(button, size);
						} else if (trackedValue.value() instanceof Double) {
							var button = new LabelledEditBox(
								this.field_22793,
								0, 0, 150, 32,
								this.configTextUtils.getOptionText(trackedValue)
							);
							button.method_1852(((Double) this.newValues.get(trackie)).toString());
							button.method_1863(value -> {
								try {
									double min = Double.NEGATIVE_INFINITY;
									double max = Double.POSITIVE_INFINITY;

									for (var constraint : trackedValue.constraints()) {
										if (constraint instanceof Constraint.Range<?> range) {
											min = Math.max(((Constraint.Range<Double>) range).min(), min);
											max = Math.min(((Constraint.Range<Double>) range).max(), max);
										}
									}

									double parsedValue = Double.parseDouble(value);
									if (parsedValue < min || parsedValue > max) {
										// Yes, this isn't exactly right but oh well
										throw new IndexOutOfBoundsException();
									}

									this.newValues.replace(trackie, parsedValue);
									this.invalidValues.remove(trackie);
									button.method_1868(0xFFE0E0E0);
								} catch (NumberFormatException | IndexOutOfBoundsException e) {
									this.invalidValues.add(trackie);
									button.method_1868(class_8012.field_41758);
								}
							});
							button.method_47400(class_7919.method_47407(this.configTextUtils.getOptionTextTooltip(trackedValue)));
							this.addOptionToList(button, size);
						} else if (trackedValue.value() instanceof Integer) {
							var button = new LabelledEditBox(
								this.field_22793,
								0, 0, 150, 32,
								this.configTextUtils.getOptionText(trackedValue)
							);
							button.method_1852(((Integer) this.newValues.get(trackie)).toString());
							button.method_1863(value -> {
								try {
									int min = Integer.MIN_VALUE;
									int max = Integer.MAX_VALUE;

									for (var constraint : trackedValue.constraints()) {
										if (constraint instanceof Constraint.Range<?> range) {
											min = Math.max(((Constraint.Range<Integer>) range).min(), min);
											max = Math.min(((Constraint.Range<Integer>) range).max(), max);
										}
									}

									int parsedValue = Integer.parseInt(value);
									if (parsedValue < min || parsedValue > max) {
										// Yes, this isn't exactly right but oh well
										throw new IndexOutOfBoundsException();
									}

									this.newValues.replace(trackie, parsedValue);
									this.invalidValues.remove(trackie);
									button.method_1868(0xFFE0E0E0);
								} catch (NumberFormatException | IndexOutOfBoundsException e) {
									this.invalidValues.add(trackie);
									button.method_1868(class_8012.field_41758);
								}
							});
							button.method_47400(class_7919.method_47407(this.configTextUtils.getOptionTextTooltip(trackedValue)));
							this.addOptionToList(button, size);
						} else if (trackedValue.value() instanceof ConfigEnums.ConfigEnum configEnum) {
							var button = class_5676.<ConfigEnums.ConfigEnum>method_32606(value -> this.configTextUtils.getEnumOptionText(trackedValue, value))
								.method_32624((ConfigEnums.ConfigEnum[]) ((Enum<?>) configEnum).getDeclaringClass().getEnumConstants())
								.method_32618(value -> class_7919.method_47407(this.configTextUtils.getEnumOptionTextTooltip(trackedValue, value)))
								.method_32619((ConfigEnums.ConfigEnum) this.newValues.get(trackie))
								.method_32617(
									0, 0, 150, 20,
									this.configTextUtils.getOptionText(trackedValue),
									(button_, value) -> this.newValues.replace(trackie, value));
							this.addOptionToList(button, size);
						}
					}
				}

				if (this.buttonBuffer != null) {
					this.selectionList.addButton(buttonBuffer, null);
					this.buttonBuffer = null;
				}
			}
		}

		this.selectionList.finish();
		this.method_37063(this.selectionList);

		this.layout.method_57726(this.field_22785, this.field_22793);
		var footerLayout = this.layout.method_48996(class_8667.method_52742().method_52735(8));
		footerLayout.method_52736(class_4185.method_46430(class_2561.method_43471("config.ok_zoomer.discard_changes"), button -> this.resetNewValues()).method_46432(150).method_46431());
		footerLayout.method_52736(class_4185.method_46430(class_5244.field_24334, button -> this.method_25419()).method_46432(150).method_46431());

		this.layout.method_48206(this::method_37063);
		this.method_48640();
	}

	@Override
	protected void method_48640() {
		this.layout.method_48222();
		this.selectionList.updateSize(this.field_22789, this.layout);
	}

	private void addOptionToList(class_339 button, WidgetSize.Size size) {
		if (size == WidgetSize.Size.HALF) {
			if (this.buttonBuffer == null) {
				this.buttonBuffer = button;
			} else {
				this.selectionList.addButton(this.buttonBuffer, button);
				this.buttonBuffer = null;
			}
		} else {
			if (this.buttonBuffer != null) {
				this.selectionList.addButton(this.buttonBuffer, null);
				this.buttonBuffer = null;
			}
			this.selectionList.addButton(button);
		}
	}

	@Override
	public void method_25419() {
		this.field_22787.method_1507(this.parent);
	}

	@Override
	public void method_25432() {
		this.newValues.forEach((trackedValue, newValue) -> {
			if (!invalidValues.contains(trackedValue)) {
				trackedValue.setValue(newValue, false);
			}
		});
		OkZoomerConfigManager.CONFIG.save();
	}

	private void refresh() {
		var scrollAmount = this.selectionList.getScrollAmount();
		this.method_41843();
		this.selectionList.setScrollAmount(scrollAmount);
	}

	private void resetNewValues() {
		this.newValues.clear();

		for (TrackedValue<?> trackedValue : OkZoomerConfigManager.CONFIG.values()) {
			if (trackedValue.getRealValue() != null) {
				newValues.put((TrackedValue<Object>) trackedValue, trackedValue.getRealValue());
			}
		}

		this.refresh();
	}

	@SuppressWarnings("unchecked")
	public void resetToPreset(ConfigEnums.ZoomPresets preset) {
		this.newValues.clear();
		this.invalidValues.clear();

		for (TrackedValue<?> trackedValue : OkZoomerConfigManager.CONFIG.values()) {
			this.newValues.put(
				(TrackedValue<Object>) trackedValue,
				ZoomPresets.PRESET_ENUM_TO_PRESET.get(preset).getOrDefault(trackedValue, trackedValue.getDefaultValue())
			);
		}

		this.refresh();
	}
}
