package io.github.ennuil.ok_zoomer.config.screen.components;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8012;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8027;
import net.minecraft.class_8028;
import net.minecraft.class_8132;
import net.minecraft.class_9017;

public class OkZoomerSelectionList extends class_9017 {
	private static final class_2960 SCROLLER_SPRITE = class_2960.method_60656("widget/scroller");
	private static final class_2960 SCROLLER_BACKGROUND_SPRITE = class_2960.method_60656("widget/scroller_background");
	private static final class_2960 MENU_LIST_BACKGROUND = class_2960.method_60656("textures/gui/menu_list_background.png");
	private static final class_2960 INWORLD_MENU_LIST_BACKGROUND = class_2960.method_60656("textures/gui/inworld_menu_list_background.png");

	private final class_310 minecraft;
	private final List<Entry> children;
	private IntList entryHeights;

	private int contentHeight;
	private int scrollAmount;
	private boolean scrolling;
	@Nullable
	private Entry hovered;

	public OkZoomerSelectionList(class_310 minecraft, int width, int height, int y) {
		super(0, y, width, height, class_5244.field_39003);
		this.minecraft = minecraft;
		this.children = new ArrayList<>();
		this.entryHeights = new IntArrayList();

		this.contentHeight = height;

		this.scrollAmount = 0;
		this.scrolling = false;

		this.hovered = null;

		this.update();
	}

	@Nullable
	public Entry method_25399() {
		return (Entry) super.method_25399();
	}

	@Override
	public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
		this.hovered = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
		this.renderListBackground(graphics);
		graphics.method_44379(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());

		int i = this.method_46427() - this.scrollAmount;
		for (var child : children) {
			int oldI = i;
			i += child.getEntryHeight();
			if (i >= this.method_46427() && oldI <= this.field_22759 + this.method_46427()) {
				int xToRender = this.method_46426() + this.field_22758 / 2 - this.getRowWidth() / 2;
				child.render(graphics, xToRender, oldI, this.getRowWidth(), mouseX, mouseY, delta);
			}
		}
		graphics.method_44380();
		this.renderListSeparators(graphics);

		if (this.contentHeight - this.field_22759 > 0) {
			this.renderScrollBar(graphics);
		}
	}

	@Override
	public void method_47399(class_6382 narrationElementOutput) {
		var hovered = this.getHovered();
		if (hovered != null) {
			hovered.updateNarration(narrationElementOutput.method_37031());
			this.narrateListElementPosition(narrationElementOutput, hovered);
		} else {
			var entry = this.method_25399();
			if (entry != null) {
				entry.updateNarration(narrationElementOutput.method_37031());
				this.narrateListElementPosition(narrationElementOutput, entry);
			}
		}

		narrationElementOutput.method_37034(class_6381.field_33791, class_2561.method_43471("narration.component_list.usage"));
	}

	protected void narrateListElementPosition(class_6382 narrationElementOutput, Entry entry) {
		List<Entry> list = this.method_25396();
		if (!list.isEmpty()) {
			int i = list.indexOf(entry);
			if (i != -1) {
				narrationElementOutput.method_37034(class_6381.field_33789, class_2561.method_43469("narrator.position.list", i + 1, list.size()));
			}
		}
	}

	@Override
	public @NotNull List<Entry> method_25396() {
		return this.children;
	}

	@Override
	public @NotNull class_6379.class_6380 method_37018() {
		if (this.method_25370()) {
			return class_6380.field_33786;
		} else {
			return this.hovered != null ? class_6380.field_33785 : class_6380.field_33784;
		}
	}

	private void renderListBackground(class_332 graphics) {
		var backgroundLocation = this.minecraft.field_1687 == null ? MENU_LIST_BACKGROUND : INWORLD_MENU_LIST_BACKGROUND;
		graphics.method_25290(class_10799.field_56883, backgroundLocation, this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443() + this.getScrollAmount(), this.field_22758, this.field_22759, 32,32);
	}

	private void renderListSeparators(class_332 graphics) {
		var headerSeparatorLocation = this.minecraft.field_1687 == null ? class_437.field_49895 : class_437.field_49897;
		var footerSeparatorLocation = this.minecraft.field_1687 == null ? class_437.field_49896 : class_437.field_49898;
		graphics.method_25290(class_10799.field_56883, headerSeparatorLocation, this.method_46426(), this.method_46427() - 2, 0.0F, 0.0F, this.field_22758, 2, 32, 2);
		graphics.method_25290(class_10799.field_56883, footerSeparatorLocation, this.method_46426(), this.method_55443(), 0.0F, 0.0F, this.field_22758, 2, 32, 2);
	}

	private void renderScrollBar(class_332 graphics) {
		int size = Math.min(this.field_22759, (this.field_22759 * this.field_22759) / this.contentHeight);
		int x = this.getScrollBarPosX();

		var scale = (this.scrollAmount / (double) (this.contentHeight - this.field_22759));
		var y = this.method_46427() + (int) (scale * (this.field_22759 - size));

		graphics.method_52706(class_10799.field_56883, SCROLLER_BACKGROUND_SPRITE, x, this.method_46427(), 6, this.field_22759);
		graphics.method_52706(class_10799.field_56883, SCROLLER_SPRITE, x, y, 6, size);
	}

	protected int getScrollBarPosX() {
		return this.field_22758 / 2 + 156;
	}

	public void update() {
		this.entryHeights = new IntArrayList();
		int contentHeight = 0;

		for (var child : this.children) {
			entryHeights.add(child.getEntryHeight());
			contentHeight += child.getEntryHeight();
		}

		this.contentHeight = Math.max(this.field_22759, contentHeight);
	}

	public void finish() {
		this.update();
	}

	public int getScrollAmount() {
		return this.scrollAmount;
	}

	public void setScrollAmount(int scrollAmount) {
		this.scrollAmount = class_3532.method_15340(scrollAmount, 0, Math.max(0, this.contentHeight - this.field_22759));
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		return mouseX >= this.method_46426() && mouseX <= this.method_55442() && mouseY >= this.method_46427() && mouseY <= this.method_55443();
	}

	@Override
	public boolean method_25402(class_11909 event, boolean isDoubleClick) {
		if (!this.scrolling) {
			int pos = (this.field_22758 - this.method_46426()) / 2 + 156;
			if (event.comp_4798() > pos && event.comp_4798() < pos + 6) {
				this.scrolling = true;
				return true;
			}
		}

		if (!this.method_25405(event.comp_4798(), event.comp_4799())) {
			return super.method_25402(event, isDoubleClick);
		} else {
			var entry = this.getEntryAtPosition(event.comp_4798(), event.comp_4799());
			if (entry != null) {
				if (entry.method_25402(event, isDoubleClick)) {
					var subEntry = this.method_25399();
					if (subEntry != entry && subEntry != null) {
						subEntry.method_25395(null);
					}

					this.method_25395(entry);
					this.method_25398(true);
					return true;
				}
			}
		}

		return this.scrolling;
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
		this.setScrollAmount((int) (this.scrollAmount - scrollY * 10));
		return true;
	}

	@Override
	public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
		if (super.method_25403(event, deltaX, deltaY)) {
			return true;
		} else if (event.method_74245() == GLFW.GLFW_MOUSE_BUTTON_1 && this.scrolling) {
			if (event.comp_4799() < this.method_46427()) {
				this.setScrollAmount(0);
			} else if (event.comp_4799() > this.method_46427() + this.field_22759) {
				this.setScrollAmount(this.contentHeight);
			} else {
				int size = class_3532.method_15340((this.field_22759 * this.field_22759) / this.contentHeight, 0, this.field_22759 - 6);
				double scale = Math.max(1.0, ((double) this.contentHeight / (this.field_22759 - size)));
				this.setScrollAmount(this.getScrollAmount() + (int) (deltaY * scale));
			}

			return true;
		}

		return false;
	}

	@Override
	public boolean method_25406(class_11909 event) {
		if (this.scrolling) {
			this.scrolling = false;
			return true;
		} else {
			return super.method_25406(event);
		}
	}

	@Override
	public void method_25395(@Nullable class_364 child) {
		super.method_25395(child);

		if(child instanceof OkZoomerSelectionList.Entry entry) {
			int i = this.children.indexOf(entry);
			if (i >= 0) {
				if (this.minecraft.method_48186().method_48183()) {
					this.ensureVisible(i);
				}
			}
		}
	}

	protected int getEntryHeightSum(int index) {
		int sum = 0;
		for (int i = 0; i < index; i++) {
			sum += this.entryHeights.getInt(i);
		}

		return sum;
	}

	protected int getRowTop(int index) {
		return this.method_46427() + 4 - this.getScrollAmount() + getEntryHeightSum(index);
	}

	public int getRowWidth() {
		return 310;
	}

	public void updateSize(int width, class_8132 headerAndFooterLayout) {
		this.updateSizeAndPosition(width, headerAndFooterLayout.method_57727(), headerAndFooterLayout.method_48998());
	}

	public void updateSizeAndPosition(int width, int height, int y) {
		this.method_55445(width, height);
		this.method_46419(y);
		this.update();
	}

	@Override
	protected int method_44395() {
		return this.contentHeight;
	}

	protected void ensureVisible(int index) {
		int rowTop = this.getRowTop(index);
		int rowTop2 = rowTop - this.method_46427() - 4 - entryHeights.getInt(index);

		if (rowTop2 < 0) {
			this.setScrollAmount(this.getScrollAmount() + rowTop2);
		}

		int rowTop3 = (this.method_46427() + this.field_22759) - rowTop - (entryHeights.getInt(index) * 2);

		if (rowTop3 < 0) {
			this.setScrollAmount(this.getScrollAmount() - rowTop3);
		}
	}

	@Override
	protected double method_44393() {
		return 10.0;
	}

	// This is so faithful to Vanilla's algo that it also inherits the Bottom Void Pixel of Doom! Oh no!
	protected final Entry getEntryAtPosition(double x, double y) {
		int center = this.method_46426() + this.field_22758 / 2;
		int halfRowWidth = this.getRowWidth() / 2;
		int rowMinX = center - halfRowWidth;
		int rowMaxX = center + halfRowWidth;

		int sum = 0;
		int i = 0;

		while (sum <= class_3532.method_15357(y - this.method_46427()) + this.scrollAmount) {
			if (i < this.entryHeights.size()) {
				sum += this.entryHeights.getInt(i);
				i++;
			} else {
				i++;
				break;
			}
		}
		i--;

		if (x < this.getScrollBarPosX() && x >= rowMinX && x <= rowMaxX && i < this.children.size()) {
			return this.children.get(i);
		}

		return null;
	}

	/*
	@Nullable
	protected Entry nextEntry(ScreenDirection direction) {
		return this.nextEntry(direction, e -> true);
	}

	@Nullable
	protected Entry nextEntry(ScreenDirection direction, Predicate<Entry> predicate) {
		return this.nextEntry(direction, predicate, (Entry) this.getFocused());
	}
	*/

	@Nullable
	protected Entry nextEntry(class_8028 direction, Predicate<Entry> predicate, @Nullable Entry currentEntry) {
		int i = switch (direction) {
			case field_41828, field_41829 -> 0;
			case field_41826 -> -1;
			case field_41827 -> 1;
		};

		if (!this.children.isEmpty() && i != 0) {
			int j;
			if (currentEntry == null) {
				j = i > 0 ? 0 : this.children.size() - 1;
			} else {
				j = this.children.indexOf(currentEntry) + i;
			}

			for (int k = j; k >= 0 && k < this.children.size(); k += i) {
				var entry = this.children.get(k);
				if (predicate.test(entry)) {
					return entry;
				}
			}
		}


		return null;
	}

	@Nullable
	@Override
	public class_8016 method_48205(class_8023 event) {
		if (this.children.isEmpty()) {
			return null;
		} else if (!(event instanceof class_8023.class_8024(class_8028 direction))) {
			return super.method_48205(event);
		} else {
			var entry = this.method_25399();

			if (direction.method_48237() == class_8027.field_41822 && entry != null) {
				return class_8016.method_48192(this, entry.method_48205(event));
			} else {
				int i = -1;
				if (entry != null) {
					i = entry.method_25396().indexOf(entry.method_25399());
				}

				if (i == -1) {
					switch (direction) {
						case field_41828 -> {
							i = Integer.MAX_VALUE;
							direction = class_8028.field_41827;
						}
						case field_41829 -> {
							i = 0;
							direction = class_8028.field_41827;
						}
						default -> i = 0;
					}
				}

				var entry2 = entry;
				class_8016 path = null;

				while (path == null) {
					entry2 = this.nextEntry(direction, entryx -> !entryx.method_25396().isEmpty(), entry2);
					if (entry2 == null) {
						return null;
					}

					path = entry2.getFocusPathAtIndex(event, i);
				}

				return class_8016.method_48192(this, path);
			}
		}
	}

	public @Nullable Entry getHovered() {
		return this.hovered;
	}

	public void addCategory(class_2561 component) {
		this.children.add(new CategoryEntry(component));
	}

	public void addButton(class_339 button) {
		this.children.add(new ButtonEntry(button));
	}

	public void addButton(class_339 leftButton, class_339 rightButton) {
		this.children.add(new ButtonEntry(leftButton, rightButton));
	}

	public abstract class Entry implements class_4069 {
		@Nullable
		private class_364 focused;
		@Nullable
		private class_6379 lastNarratable;
		private boolean dragging;

		public abstract void render(class_332 graphics, int x, int y, int rowWidth, int mouseX, int mouseY, float delta);

		public abstract int getEntryHeight();

		@Override
		public boolean method_25397() {
			return this.dragging;
		}

		@Override
		public void method_25398(boolean dragging) {
			this.dragging = dragging;
		}

		@Nullable
		@Override
		public class_364 method_25399() {
			return this.focused;
		}

		@Override
		public boolean method_25370() {
			return OkZoomerSelectionList.this.method_25399() == this;
		}

		@Override
		public void method_25395(@Nullable class_364 focused) {
			if (this.focused != null) {
				this.focused.method_25365(false);
			}

			if (focused != null) {
				focused.method_25365(true);
			}

			this.focused = focused;
		}

		@Nullable
		public class_8016 getFocusPathAtIndex(class_8023 event, int index) {
			if (this.method_25396().isEmpty()) {
				return null;
			} else {
				var path = (this.method_25396().get(Math.min(index, this.method_25396().size() - 1))).method_48205(event);
				return class_8016.method_48192(this, path);
			}
		}

		@Nullable
		@Override
		public class_8016 method_48205(class_8023 event) {
			if (event instanceof class_8023.class_8024(class_8028 direction)) {
				int i = switch (direction) {
					case field_41828 -> -1;
					case field_41829 -> 1;
					case field_41826, field_41827 -> 0;
				};

				if (i == 0) return null;

				int j = class_3532.method_15340(i + this.method_25396().indexOf(this.method_25399()), 0, this.method_25396().size() - 1);

				for (int k = j; k >= 0 && k < this.method_25396().size(); k += i) {
					var guiEventListener = (class_364) this.method_25396().get(k);
					var path = guiEventListener.method_48205(event);
					if (path != null) {
						return class_8016.method_48192(this, path);
					}
				}
			}

			return class_4069.super.method_48205(event);
		}

		void updateNarration(class_6382 narrationElementOutput) {
			var list = this.narratables();
			var narrationData = class_437.method_37061(list, this.lastNarratable);
			if (narrationData != null) {
				if (narrationData.comp_4465().method_37028()) {
					this.lastNarratable = narrationData.comp_4463();
				}

				if (!list.isEmpty()) {
					narrationElementOutput.method_37034(class_6381.field_33789, class_2561.method_43469("narrator.position.object_list", narrationData.comp_4464() + 1, list.size()));
					if (narrationData.comp_4465() == class_6379.class_6380.field_33786) {
						narrationElementOutput.method_37034(class_6381.field_33791, class_2561.method_43471("narration.component_list.usage"));
					}
				}

				narrationData.comp_4463().method_37020(narrationElementOutput.method_37031());
			}
		}

		public abstract List<? extends class_6379> narratables();
	}

	class CategoryEntry extends Entry {
		private final class_2561 title;

		private CategoryEntry(class_2561 title) {
			this.title = title;
		}

		@Override
		public void render(class_332 graphics, int x, int y, int rowWidth, int mouseX, int mouseY, float delta) {
			graphics.method_25294(x, y + 1, x + rowWidth, y + 19, 0xA0000000);
			graphics.method_27534(OkZoomerSelectionList.this.minecraft.field_1772, this.title, x + rowWidth / 2, y + 6, class_8012.field_42973);
		}

		@Override
		public @Nullable class_8016 method_48205(class_8023 event) {
			return null;
		}

		@Override
		public int getEntryHeight() {
			return 20;
		}

		@Override
		public @NotNull List<? extends class_364> method_25396() {
			return List.of();
		}

		@Override
		public List<? extends class_6379> narratables() {
			return List.of(new class_6379() {
				@Override
				public @NotNull class_6380 method_37018() {
					return class_6380.field_33785;
				}

				@Override
				public void method_37020(class_6382 narrationElementOutput) {
					narrationElementOutput.method_37034(class_6381.field_33788, CategoryEntry.this.title);
				}
			});
		}
	}

	class ButtonEntry extends Entry {
		private final class_339 leftButton;
		private final class_339 rightButton;
		private final int entryHeight;
		private final List<class_339> buttons;

		public ButtonEntry(class_339 button) {
			button.method_25358(310);
			this.leftButton = button;
			this.rightButton = null;
			this.entryHeight = button.method_25364() + 4;
			this.buttons = List.of(button);
		}

		public ButtonEntry(class_339 leftButton, class_339 rightButton) {
			this.leftButton = leftButton;
			this.rightButton = rightButton;
			this.entryHeight = (rightButton != null ? Math.max(leftButton.method_25364(), rightButton.method_25364()) : leftButton.method_25364()) + 4;
			this.buttons = rightButton != null ? List.of(leftButton, rightButton) : List.of(leftButton);
		}

		@Override
		public void render(class_332 graphics, int x, int y, int rowWidth, int mouseX, int mouseY, float delta) {
			this.leftButton.method_48229(x, y + 2);
			this.leftButton.method_25394(graphics, mouseX, mouseY, delta);

			if (this.rightButton != null) {
				this.rightButton.method_48229(x + 160, y + 2);
				this.rightButton.method_25394(graphics, mouseX, mouseY, delta);
			}
		}

		// Yes, I don't exactly like this either, but this allows for gaps of 5 pixels as well as a nice bottom padding
		// against the end of the page
		// (This used to be a hardcoded reference to 24)
		@Override
		public int getEntryHeight() {
			return this.entryHeight;
		}

		@Override
		public @NotNull List<? extends class_364> method_25396() {
			return this.buttons;
		}

		@Override
		public List<? extends class_6379> narratables() {
			return this.buttons;
		}
	}
}
