package io.github.ennuil.ok_zoomer.events;

import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.key_binds.ZoomKeyBinds;
import io.github.ennuil.ok_zoomer.utils.ZoomUtils;
import net.minecraft.class_310;

// This event manages the extra key binds' behavior
public class ManageExtraKeysEvent {
	public static void startClientTick(class_310 minecraft) {
		if (!ZoomKeyBinds.areExtraKeyBindsEnabled()) return;
		if (!OkZoomerConfigManager.CONFIG.features.extraKeyBinds.value()) return;

		if (ZoomKeyBinds.DECREASE_ZOOM_KEY.method_1434() && !ZoomKeyBinds.INCREASE_ZOOM_KEY.method_1434()) {
			ZoomUtils.changeZoomDivisor(false);
		}

		if (ZoomKeyBinds.INCREASE_ZOOM_KEY.method_1434() && !ZoomKeyBinds.DECREASE_ZOOM_KEY.method_1434()) {
			ZoomUtils.changeZoomDivisor(true);
		}

		if (ZoomKeyBinds.RESET_ZOOM_KEY.method_1434()) {
			ZoomUtils.resetZoomDivisor(true);
		}
	}
}
