package io.github.ennuil.ok_zoomer.zoom.overlays;

import io.github.ennuil.ok_zoomer.zoom.transitions.TransitionMode;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import net.minecraft.class_9848;

// Implements the zoom overlay
public class ZoomerZoomOverlay implements ZoomOverlay {
	private final class_2960 textureId;
	private boolean active;

	public ZoomerZoomOverlay(class_2960 textureId) {
		this.textureId = textureId;
		this.active = false;
	}

	@Override
	public boolean getActive() {
		return this.active;
	}

	@Override
	public void renderOverlay(class_332 graphics, class_9779 deltaTracker, TransitionMode transitionMode) {
		float fade = transitionMode.getFade(deltaTracker.method_60637(true));
		int color = class_9848.method_61318(1.0F, fade, fade, fade);
		graphics.method_25291(class_10799.field_56889, this.textureId, 0, 0, 0.0F, 0.0F, graphics.method_51421(), graphics.method_51443(), graphics.method_51421(), graphics.method_51443(), color);
	}

	@Override
	public void tick(boolean active, double divisor, TransitionMode transitionMode) {
		if (active || !transitionMode.getActive()) {
			this.active = active;
		}
	}
}
