/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.config;

import net.minecraft.resources.Identifier;
import page.langeweile.ok_zoomer.config.ConfigEnums;
import page.langeweile.ok_zoomer.config.OkZoomerConfig;
import page.langeweile.ok_zoomer.utils.ModUtils;
import page.langeweile.ok_zoomer.zoom.Zoom;
import page.langeweile.ok_zoomer.zoom.modifiers.CinematicCameraMouseModifier;
import page.langeweile.ok_zoomer.zoom.modifiers.ContainingMouseModifier;
import page.langeweile.ok_zoomer.zoom.modifiers.MouseModifier;
import page.langeweile.ok_zoomer.zoom.modifiers.MultipliedCinematicCameraMouseModifier;
import page.langeweile.ok_zoomer.zoom.modifiers.ZoomDivisorMouseModifier;
import page.langeweile.ok_zoomer.zoom.overlays.SpyglassZoomOverlay;
import page.langeweile.ok_zoomer.zoom.overlays.ZoomerZoomOverlay;
import page.langeweile.ok_zoomer.zoom.transitions.InstantTransitionMode;
import page.langeweile.ok_zoomer.zoom.transitions.LinearTransitionMode;
import page.langeweile.ok_zoomer.zoom.transitions.SmoothTransitionMode;
import page.langeweile.wrench_wrapper.api.WrenchWrapper;

public class OkZoomerConfigManager {
    public static final OkZoomerConfig CONFIG = (OkZoomerConfig)WrenchWrapper.create((String)"ok_zoomer", (String)"config", OkZoomerConfig.class);

    public static void init() {
        OkZoomerConfigManager.configureZoomInstance();
        CONFIG.registerCallback(config -> OkZoomerConfigManager.configureZoomInstance());
    }

    public static void configureZoomInstance() {
        Zoom.setTransitionMode(switch ((ConfigEnums.ZoomTransitionOptions)OkZoomerConfigManager.CONFIG.features.zoomTransition.value()) {
            case ConfigEnums.ZoomTransitionOptions.SMOOTH -> new SmoothTransitionMode(((Double)OkZoomerConfigManager.CONFIG.transitionValues.smoothTransitionFactor.value()).floatValue());
            case ConfigEnums.ZoomTransitionOptions.LINEAR -> new LinearTransitionMode((Double)OkZoomerConfigManager.CONFIG.transitionValues.linearStep.value());
            default -> new InstantTransitionMode();
        });
        OkZoomerConfigManager.configureZoomModifier();
        Identifier overlayTextureId = OkZoomerConfigManager.CONFIG.features.zoomOverlay.value() == ConfigEnums.ZoomOverlays.SPYGLASS ? Identifier.withDefaultNamespace((String)"textures/misc/spyglass_scope.png") : ModUtils.id("textures/misc/zoom_overlay.png");
        Zoom.setZoomOverlay(switch ((ConfigEnums.ZoomOverlays)OkZoomerConfigManager.CONFIG.features.zoomOverlay.value()) {
            case ConfigEnums.ZoomOverlays.VIGNETTE -> new ZoomerZoomOverlay(overlayTextureId);
            case ConfigEnums.ZoomOverlays.SPYGLASS -> new SpyglassZoomOverlay(overlayTextureId);
            default -> null;
        });
    }

    public static void configureZoomModifier() {
        ConfigEnums.CinematicCameraOptions cinematicCamera = (ConfigEnums.CinematicCameraOptions)OkZoomerConfigManager.CONFIG.features.cinematicCamera.value();
        boolean reduceSensitivity = (Boolean)OkZoomerConfigManager.CONFIG.features.reduceSensitivity.value();
        if (cinematicCamera != ConfigEnums.CinematicCameraOptions.OFF) {
            MouseModifier cinematicModifier = switch (cinematicCamera) {
                case ConfigEnums.CinematicCameraOptions.VANILLA -> new CinematicCameraMouseModifier();
                case ConfigEnums.CinematicCameraOptions.MULTIPLIED -> new MultipliedCinematicCameraMouseModifier((Double)OkZoomerConfigManager.CONFIG.zoomValues.cinematicMultiplier.value());
                default -> null;
            };
            Zoom.setMouseModifier(reduceSensitivity ? new ContainingMouseModifier(cinematicModifier, new ZoomDivisorMouseModifier()) : cinematicModifier);
        } else {
            Zoom.setMouseModifier(reduceSensitivity ? new ZoomDivisorMouseModifier() : null);
        }
    }
}

