/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import page.langeweile.ok_zoomer.config.ConfigEnums;
import page.langeweile.ok_zoomer.config.OkZoomerConfigManager;
import page.langeweile.ok_zoomer.utils.ZoomUtils;
import page.langeweile.ok_zoomer.zoom.Zoom;
import page.langeweile.ok_zoomer.zoom.overlays.ZoomOverlay;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Unique
    private float translation = 0.0f;
    @Unique
    private float scale = 0.0f;

    @Inject(method={"renderCameraOverlays"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/DeltaTracker;getGameTimeDeltaTicks()F")})
    private void injectZoomOverlay(GuiGraphics graphics, DeltaTracker deltaTracker, CallbackInfo ci, @Share(value="cancelOverlay") LocalBooleanRef cancelOverlay) {
        cancelOverlay.set(false);
        if (Zoom.getZoomOverlay() != null) {
            ZoomOverlay overlay = Zoom.getZoomOverlay();
            overlay.tickBeforeRender(deltaTracker);
            if (overlay.getActive()) {
                cancelOverlay.set(overlay.cancelOverlayRendering());
                overlay.renderOverlay(graphics, deltaTracker, Zoom.getTransitionMode());
            }
        }
    }

    @ModifyExpressionValue(method={"renderCameraOverlays"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/CameraType;isFirstPerson()Z")})
    private boolean cancelOverlay(boolean original, @Share(value="cancelOverlay") LocalBooleanRef cancelOverlay) {
        return original && !cancelOverlay.get();
    }

    @ModifyExpressionValue(method={"renderCameraOverlays"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isScoping()Z")})
    private boolean activateSpyglassOverlay(boolean isScoping) {
        block3: {
            switch ((ConfigEnums.SpyglassModes)OkZoomerConfigManager.CONFIG.features.spyglassMode.value()) {
                case REPLACE_ZOOM: 
                case BOTH: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            return false;
        }
        return isScoping;
    }

    @WrapMethod(method={"render"})
    private void zoomGui(GuiGraphics graphics, DeltaTracker deltaTracker, Operation<Void> original) {
        if (((Boolean)OkZoomerConfigManager.CONFIG.features.persistentInterface.value()).booleanValue() || !Zoom.getTransitionMode().getActive()) {
            original.call(new Object[]{graphics, deltaTracker});
        } else {
            float fov = Zoom.getTransitionMode().applyZoom(1.0f, deltaTracker.getGameTimeDeltaPartialTick(true));
            this.translation = 2.0f / (1.0f / fov - 1.0f);
            this.scale = 1.0f / fov;
            graphics.pose().pushMatrix();
            graphics.pose().translate(-((float)graphics.guiWidth() / this.translation), -((float)graphics.guiHeight() / this.translation));
            graphics.pose().scale(this.scale, this.scale);
            original.call(new Object[]{graphics, deltaTracker});
            graphics.pose().popMatrix();
        }
    }

    @WrapMethod(method={"renderCrosshair"})
    private void hideCrosshair(GuiGraphics graphics, DeltaTracker deltaTracker, Operation<Void> original) {
        boolean persistentInterface = (Boolean)OkZoomerConfigManager.CONFIG.features.persistentInterface.value();
        boolean hideCrosshair = (Boolean)OkZoomerConfigManager.CONFIG.features.hideCrosshair.value();
        if (persistentInterface || hideCrosshair || !Zoom.isTransitionActive()) {
            original.call(new Object[]{graphics, deltaTracker});
        } else {
            graphics.pose().popMatrix();
            original.call(new Object[]{graphics, deltaTracker});
            graphics.pose().pushMatrix();
            graphics.pose().translate(-((float)graphics.guiWidth() / this.translation), -((float)graphics.guiHeight() / this.translation));
            graphics.pose().scale(this.scale, this.scale);
        }
    }

    @WrapMethod(method={"renderCrosshair"})
    private void fadeCrosshair(GuiGraphics guiGraphics, DeltaTracker deltaTracker, Operation<Void> original) {
        if (((Boolean)OkZoomerConfigManager.CONFIG.features.hideCrosshair.value()).booleanValue()) {
            ZoomUtils.setFadeModifier(Float.valueOf(1.0f - Zoom.getTransitionMode().getFade(Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true))));
            original.call(new Object[]{guiGraphics, deltaTracker});
            ZoomUtils.setFadeModifier(null);
        } else {
            original.call(new Object[]{guiGraphics, deltaTracker});
        }
    }
}

