/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;
import simpletextoverlay.config.OverlayConfig;
import simpletextoverlay.overlay.BiomeInfo;
import simpletextoverlay.overlay.DaysInfo;
import simpletextoverlay.overlay.FootInfo;
import simpletextoverlay.overlay.HudCompass;
import simpletextoverlay.overlay.Info;
import simpletextoverlay.overlay.LightInfo;
import simpletextoverlay.overlay.SeasonInfo;
import simpletextoverlay.overlay.TimeInfo;
import technology.roughness.whitenoise.platform.Services;

public class OverlayManager {
    public static final OverlayManager INSTANCE = new OverlayManager();
    public List<Info> lines = new ArrayList<Info>();
    public final HudCompass hudCompass = new HudCompass();

    private OverlayManager() {
    }

    public void init() {
        int lineNum = 1;
        this.lines.clear();
        for (String fieldName : OverlayConfig.fields()) {
            boolean skip = false;
            switch (fieldName) {
                case "light": {
                    this.lines.add(new LightInfo(OverlayConfig.lightLabel(), lineNum));
                    break;
                }
                case "foot": {
                    this.lines.add(new FootInfo(OverlayConfig.footLabel(), lineNum));
                    break;
                }
                case "biome": {
                    this.lines.add(new BiomeInfo(OverlayConfig.biomeLabel(), lineNum));
                    break;
                }
                case "time": {
                    this.lines.add(new TimeInfo(OverlayConfig.timeLabel(), lineNum));
                    break;
                }
                case "days": {
                    this.lines.add(new DaysInfo(OverlayConfig.daysLabel(), lineNum));
                    break;
                }
                case "season": {
                    if (Services.PLATFORM.isModLoaded("sereneseasons") || Services.PLATFORM.isModLoaded("seasons") || Services.PLATFORM.isModLoaded("eclipticseasons")) {
                        this.lines.add(new SeasonInfo("", lineNum));
                        break;
                    }
                    skip = true;
                }
            }
            if (skip) continue;
            ++lineNum;
        }
    }

    public void renderOverlay(class_332 guiGraphics, float partialTicks) {
        class_310 mc = class_310.method_1551();
        class_2338 pos = Objects.requireNonNull(mc.method_1560()).method_24515();
        if (mc.field_1687 != null && mc.field_1687.method_8477(pos)) {
            float scale = (float)OverlayConfig.scale();
            int scaledWidth = (int)((float)mc.method_22683().method_4486() / scale);
            int scaledHeight = (int)((float)mc.method_22683().method_4502() / scale);
            Matrix3x2fStack matrix = guiGraphics.method_51448();
            matrix.pushMatrix();
            matrix.scale(scale, scale);
            for (Info line : this.lines) {
                line.renderText(guiGraphics, mc, pos, scaledWidth, scaledHeight);
            }
            if (OverlayConfig.showCompass()) {
                this.hudCompass.renderText(guiGraphics, mc, scaledWidth, partialTicks);
            }
            matrix.popMatrix();
        }
    }
}

