/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay;

import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_332;
import simpletextoverlay.config.OverlayConfig;
import simpletextoverlay.overlay.Info;
import simpletextoverlay.util.Alignment;
import simpletextoverlay.util.ColorHelper;
import simpletextoverlay.util.FontHelper;

public class TimeInfo
extends Info {
    public TimeInfo(String label, int lineNum) {
        super(label, lineNum);
    }

    @Override
    public void renderText(class_332 guiGraphics, class_310 mc, class_2338 pos, int scaledWidth, int scaledHeight) {
        String formattedTime;
        long hour;
        long time = Objects.requireNonNull(mc.method_1560()).method_73183().method_8532();
        long ampmHour = hour = (time / 1000L + 6L) % 24L;
        long minute = time % 1000L * 60L / 1000L;
        String ampm = "AM";
        if (!OverlayConfig.timeUse12()) {
            formattedTime = String.format(Locale.ENGLISH, "%d:%02d", hour, minute);
        } else {
            if (ampmHour >= 12L) {
                ampmHour -= 12L;
                ampm = "PM";
            }
            if (ampmHour == 0L) {
                ampmHour += 12L;
            }
            formattedTime = String.format(Locale.ENGLISH, "%d:%02d %s", ampmHour, minute, ampm);
        }
        int x = Alignment.getX(scaledWidth, mc.field_1772.method_1727(this.label + formattedTime));
        Objects.requireNonNull(mc.field_1772);
        int y = Alignment.getY(scaledHeight, this.lineNum, 9);
        FontHelper.draw(mc, guiGraphics, this.label, x, y, OverlayConfig.labelColor().getRGB(), FontHelper.TextType.LABEL);
        FontHelper.draw(mc, guiGraphics, formattedTime, x += mc.field_1772.method_1727(this.label), y, ColorHelper.getTimeColor(hour, minute), FontHelper.TextType.VALUE);
    }
}

