/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay.compass;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import simpletextoverlay.overlay.compass.Pin;
import simpletextoverlay.overlay.compass.PinInfo;
import simpletextoverlay.overlay.compass.PinInfoType;

public class PinInfoRegistry {
    public static final BiMap<class_2960, PinInfoType<?>> typesMap = HashBiMap.create();
    public static final BiMap<Integer, PinInfoType<?>> idsMap = HashBiMap.create();
    private static final class_2960 LOCATION = class_2960.method_60655((String)"simpletextoverlay", (String)"pin");
    public static PinInfoType<Pin> TYPE = new PinInfoType<Pin>(Pin::new, LOCATION);

    public static void init() {
    }

    public static class_2487 serializePin(@NotNull PinInfo<?> pinData) {
        PinInfoType<?> type = pinData.getType();
        class_2960 typeId = type.getName();
        if (typeId == null) {
            throw new IllegalStateException(String.format("Serializer name is null %s", type.getClass().getName()));
        }
        class_2487 tag = new class_2487();
        tag.method_10582("PinType", type.getName().toString());
        return pinData.write(tag);
    }

    @NotNull
    public static PinInfo<?> deserializePin(class_2487 tag) {
        if (tag.method_10558("PinType").isPresent()) {
            class_2960 typeId = class_2960.method_12838((String)((String)tag.method_10558("PinType").get()), (char)':');
            PinInfoType type = (PinInfoType)typesMap.get((Object)typeId);
            if (type == null) {
                throw new IllegalStateException(String.format("Serializer not registered %s", typeId));
            }
            Object info = type.create();
            ((PinInfo)info).read(tag);
            return info;
        }
        throw new IllegalStateException("Pin type not specified in tag");
    }

    public static void serializePin(PinInfo<?> pinData, class_2540 buffer) {
        PinInfoType<?> type = pinData.getType();
        int id = (Integer)idsMap.inverse().get(type);
        buffer.method_10804(id);
        pinData.writeToPacket(buffer);
    }

    @NotNull
    public static PinInfo<?> deserializePin(class_2540 buffer) {
        int id = buffer.method_10816();
        PinInfoType serializer = (PinInfoType)idsMap.get((Object)id);
        if (serializer == null) {
            throw new IllegalStateException("Server returned unknown serializer");
        }
        Object info = serializer.create();
        ((PinInfo)info).readFromPacket(buffer);
        return info;
    }

    static {
        typesMap.put((Object)LOCATION, TYPE);
        idsMap.put((Object)1, TYPE);
    }
}

