/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay;

import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import simpletextoverlay.config.OverlayConfig;
import simpletextoverlay.overlay.Info;
import simpletextoverlay.util.Alignment;
import simpletextoverlay.util.FontHelper;

public class DaysInfo
extends Info {
    public DaysInfo(String label, int lineNum) {
        super(label, lineNum);
    }

    @Override
    public void renderText(GuiGraphics guiGraphics, Minecraft mc, BlockPos pos, int scaledWidth, int scaledHeight) {
        String numberDays = String.format(Locale.ENGLISH, "%d", Math.max(Objects.requireNonNull(mc.level).getDayTime() / 24000L, 1L));
        int x = Alignment.getX(scaledWidth, mc.font.width(this.label + numberDays));
        Objects.requireNonNull(mc.font);
        int y = Alignment.getY(scaledHeight, this.lineNum, 9);
        FontHelper.draw(mc, guiGraphics, this.label, x, y, OverlayConfig.labelColor().getRGB(), FontHelper.TextType.LABEL);
        FontHelper.draw(mc, guiGraphics, numberDays, x += mc.font.width(this.label), y, OverlayConfig.daysColor().getRGB(), FontHelper.TextType.VALUE);
    }
}

