/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.Level;
import simpletextoverlay.overlay.Info;
import simpletextoverlay.platform.Services;
import simpletextoverlay.util.Alignment;
import simpletextoverlay.util.ColorHelper;
import simpletextoverlay.util.FontHelper;
import simpletextoverlay.util.SubSeason;

public class SeasonInfo
extends Info {
    public SeasonInfo(String label, int lineNum) {
        super(label, lineNum);
    }

    @Override
    public void renderText(GuiGraphics guiGraphics, Minecraft mc, BlockPos pos, int scaledWidth, int scaledHeight) {
        Pair<Component, SubSeason> seasonInfo = Services.SEASON_INFO.getSeasonName((Level)mc.level, pos);
        if (seasonInfo != null) {
            SubSeason subSeason = (SubSeason)((Object)seasonInfo.getSecond());
            Component seasonName = (Component)seasonInfo.getFirst();
            int x = Alignment.getX(scaledWidth, mc.font.width(this.label) + mc.font.width((FormattedText)seasonName));
            Objects.requireNonNull(mc.font);
            int y = Alignment.getY(scaledHeight, this.lineNum, 9);
            FontHelper.draw(mc, guiGraphics, seasonName, x, y, ColorHelper.getSeasonColor(subSeason), FontHelper.TextType.VALUE);
        }
    }
}

