/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay.compass;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import simpletextoverlay.overlay.compass.PinInfoType;

public abstract class PinInfo<T extends PinInfo<T>> {
    private final PinInfoType<? extends T> type;
    private String internalId;

    public PinInfo(PinInfoType<? extends T> type, String id) {
        this.type = type;
        this.internalId = id;
    }

    public PinInfoType<? extends T> getType() {
        return this.type;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public abstract Vec3 getPosition();

    public final CompoundTag write(CompoundTag tag) {
        tag.putString("ID", this.internalId);
        this.serializeAdditional(tag);
        return tag;
    }

    public final void read(CompoundTag tag) {
        if (tag.getString("ID").isPresent()) {
            this.internalId = (String)tag.getString("ID").get();
            this.deserializeAdditional(tag);
        }
    }

    public final void writeToPacket(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.internalId, 1024);
        this.writeToPacketWithoutId(buffer);
    }

    public final void writeToPacketWithoutId(FriendlyByteBuf buffer) {
        this.serializeAdditional(buffer);
    }

    public final void readFromPacket(FriendlyByteBuf buffer) {
        this.internalId = buffer.readUtf();
        this.readFromPacketWithoutId(buffer);
    }

    public final void readFromPacketWithoutId(FriendlyByteBuf buffer) {
        this.deserializeAdditional(buffer);
    }

    protected abstract void serializeAdditional(CompoundTag var1);

    protected abstract void deserializeAdditional(CompoundTag var1);

    protected abstract void serializeAdditional(FriendlyByteBuf var1);

    protected abstract void deserializeAdditional(FriendlyByteBuf var1);
}

