/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.config;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import simpletextoverlay.common.Translations;
import simpletextoverlay.overlay.OverlayManager;
import simpletextoverlay.util.Alignment;
import simpletextoverlay.util.ColorHelper;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public final class OverlayConfig {
    public static boolean loaded;
    public static final WhiteNoiseConfigSpec CLIENT_SPEC;
    private static final Client CLIENT;

    public static void init() {
        List fields = (List)OverlayConfig.CLIENT.fields.get();
        Client.sortedFields = new ArrayList<String>(fields);
        if (((Alignment.AlignmentType)((Object)OverlayConfig.CLIENT.position.get())).name().startsWith("BOTTOM")) {
            Collections.reverse(Client.sortedFields);
        }
        String[] lightColors = ((String)OverlayConfig.CLIENT.lightColorRange.get()).split("->");
        String[] timeColors = ((String)OverlayConfig.CLIENT.timeColorRange.get()).split("->");
        Client.lightColorDark = ColorHelper.decode(lightColors[0]);
        Client.lightColorBright = ColorHelper.decode(lightColors[1]);
        Client.timeColorDark = ColorHelper.decode(timeColors[0]);
        Client.timeColorBright = ColorHelper.decode(timeColors[1]);
        Client.labelColorDecoded = ColorHelper.decode((String)OverlayConfig.CLIENT.labelColor.get());
        Client.footColorDecoded = ColorHelper.decode((String)OverlayConfig.CLIENT.footColor.get());
        Client.biomeColorDecoded = ColorHelper.decode((String)OverlayConfig.CLIENT.biomeColor.get());
        Client.daysColorDecoded = ColorHelper.decode((String)OverlayConfig.CLIENT.daysColor.get());
        OverlayManager.INSTANCE.init();
        loaded = true;
    }

    public static Alignment.AlignmentType position() {
        return (Alignment.AlignmentType)((Object)OverlayConfig.CLIENT.position.get());
    }

    public static int offsetX() {
        return (Integer)OverlayConfig.CLIENT.offsetX.get();
    }

    public static int offsetY() {
        return (Integer)OverlayConfig.CLIENT.offsetY.get();
    }

    public static double scale() {
        return (Double)OverlayConfig.CLIENT.scale.get();
    }

    public static List<String> fields() {
        return Client.sortedFields;
    }

    public static boolean textShadow() {
        return (Boolean)OverlayConfig.CLIENT.textShadow.get();
    }

    public static Color labelColor() {
        return Client.labelColorDecoded;
    }

    public static String lightLabel() {
        return (String)OverlayConfig.CLIENT.lightLabel.get();
    }

    public static Color lightColorDark() {
        return Client.lightColorDark;
    }

    public static Color lightColorBright() {
        return Client.lightColorBright;
    }

    public static String timeLabel() {
        return (String)OverlayConfig.CLIENT.timeLabel.get();
    }

    public static Color timeColorDark() {
        return Client.timeColorDark;
    }

    public static Color timeColorBright() {
        return Client.timeColorBright;
    }

    public static boolean timeUse12() {
        return (Boolean)OverlayConfig.CLIENT.timeUse12.get();
    }

    public static String footLabel() {
        return (String)OverlayConfig.CLIENT.footLabel.get();
    }

    public static Color footColor() {
        return Client.footColorDecoded;
    }

    public static String biomeLabel() {
        return (String)OverlayConfig.CLIENT.biomeLabel.get();
    }

    public static Color biomeColor() {
        return Client.biomeColorDecoded;
    }

    public static boolean showCompass() {
        return (Boolean)OverlayConfig.CLIENT.showCompass.get();
    }

    private static Supplier<List<? extends String>> getFields() {
        return () -> Arrays.asList(Client.defaultFields);
    }

    public static int getCompassOpacity() {
        return (Integer)OverlayConfig.CLIENT.compassOpacity.get();
    }

    public static String daysLabel() {
        return (String)OverlayConfig.CLIENT.daysLabel.get();
    }

    public static Color daysColor() {
        return Client.daysColorDecoded;
    }

    private static String getTranslation(String key) {
        return Translations.get(key);
    }

    static {
        Pair specPairClient = new WhiteNoiseConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (WhiteNoiseConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
    }

    public static class Client {
        private static final List<String> fieldList = List.of("fields");
        public static final String[] fieldStrings = new String[]{"light", "time", "days", "foot", "biome", "season"};
        private static final Predicate<Object> fieldStringValidator = s -> s instanceof String && Arrays.asList(fieldStrings).contains(s);
        private static final String[] defaultFields = new String[]{"light", "time", "foot", "biome", "season"};
        private static List<String> sortedFields;
        private static Color lightColorDark;
        private static Color lightColorBright;
        private static Color timeColorDark;
        private static Color timeColorBright;
        private static Color labelColorDecoded;
        private static Color footColorDecoded;
        private static Color biomeColorDecoded;
        private static Color daysColorDecoded;
        private static final Predicate<Object> hexValidator;
        private static final Predicate<Object> hexRangeValidator;
        public final WhiteNoiseConfigSpec.BooleanValue textShadow;
        public final WhiteNoiseConfigSpec.EnumValue<Alignment.AlignmentType> position;
        public final WhiteNoiseConfigSpec.IntValue offsetX;
        public final WhiteNoiseConfigSpec.IntValue offsetY;
        public final WhiteNoiseConfigSpec.DoubleValue scale;
        public final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> fields;
        public final WhiteNoiseConfigSpec.ConfigValue<String> labelColor;
        public final WhiteNoiseConfigSpec.ConfigValue<String> lightLabel;
        public final WhiteNoiseConfigSpec.ConfigValue<String> lightColorRange;
        public final WhiteNoiseConfigSpec.ConfigValue<String> timeLabel;
        public final WhiteNoiseConfigSpec.ConfigValue<String> timeColorRange;
        public final WhiteNoiseConfigSpec.BooleanValue timeUse12;
        public final WhiteNoiseConfigSpec.ConfigValue<String> footLabel;
        public final WhiteNoiseConfigSpec.ConfigValue<String> footColor;
        public final WhiteNoiseConfigSpec.ConfigValue<String> biomeLabel;
        public final WhiteNoiseConfigSpec.ConfigValue<String> biomeColor;
        public final WhiteNoiseConfigSpec.ConfigValue<String> daysLabel;
        public final WhiteNoiseConfigSpec.ConfigValue<String> daysColor;
        public final WhiteNoiseConfigSpec.BooleanValue showCompass;
        public final WhiteNoiseConfigSpec.IntValue compassOpacity;

        public Client(WhiteNoiseConfigSpec.Builder builder) {
            this.position = builder.comment(OverlayConfig.getTranslation("position")).defineEnum("position", (Enum)Alignment.AlignmentType.BOTTOMRIGHT);
            this.offsetX = builder.comment(OverlayConfig.getTranslation("offsetx")).defineInRange("offsetX", 3, -100, 100);
            this.offsetY = builder.comment(OverlayConfig.getTranslation("offsety")).defineInRange("offsetY", 3, -100, 100);
            this.scale = builder.comment(OverlayConfig.getTranslation("scale")).defineInRange("scale", 1.0, 0.5, 2.0);
            this.fields = builder.comment(OverlayConfig.getTranslation("fields")).defineListAllowEmpty(fieldList, OverlayConfig.getFields(), fieldStringValidator);
            this.textShadow = builder.comment(OverlayConfig.getTranslation("textshadow")).define("textShadow", true);
            this.labelColor = builder.comment(OverlayConfig.getTranslation("labelcolor")).define("labelColor", (Object)"#9c9d97", hexValidator);
            this.lightLabel = builder.comment(OverlayConfig.getTranslation("lightlabel")).define("lightLabel", (Object)"Light: ");
            this.lightColorRange = builder.comment(OverlayConfig.getTranslation("lightcolorrange")).define("lightColorRange", (Object)"#b02e26->#ffd83d", hexRangeValidator);
            this.timeLabel = builder.comment(OverlayConfig.getTranslation("timelabel")).define("timeLabel", (Object)"");
            this.timeColorRange = builder.comment(OverlayConfig.getTranslation("timecolorrange")).define("timeColorRange", (Object)"#474f52->#ffd83d", hexRangeValidator);
            this.timeUse12 = builder.comment(OverlayConfig.getTranslation("timeuse12")).define("timeUse12", true);
            this.footLabel = builder.comment(OverlayConfig.getTranslation("footlabel")).define("footLabel", (Object)"Foot level: ");
            this.footColor = builder.comment(OverlayConfig.getTranslation("footcolor")).define("footColor", (Object)"#5d7c15", hexValidator);
            this.biomeLabel = builder.comment(OverlayConfig.getTranslation("biomelabel")).define("biomeLabel", (Object)"Biome: ");
            this.biomeColor = builder.comment(OverlayConfig.getTranslation("biomecolor")).define("biomeColor", (Object)"#474f52", hexValidator);
            this.showCompass = builder.comment(OverlayConfig.getTranslation("enabled")).define("enabled", true);
            this.compassOpacity = builder.comment(OverlayConfig.getTranslation("compassopacity")).defineInRange("compassOpacity", 10, 0, 100);
            this.daysLabel = builder.comment(OverlayConfig.getTranslation("dayslabel")).define("daysLabel", (Object)"Day: ");
            this.daysColor = builder.comment(OverlayConfig.getTranslation("dayscolor")).define("daysColor", (Object)"#3c44a9", hexValidator);
        }

        static {
            lightColorDark = ColorHelper.decode("#b02e26");
            lightColorBright = ColorHelper.decode("#ffd83d");
            timeColorDark = ColorHelper.decode("#474f52");
            timeColorBright = ColorHelper.decode("#ffd83d");
            hexValidator = s -> s instanceof String && ((String)s).matches("#[a-fA-F\\d]{6}");
            hexRangeValidator = s -> s instanceof String && ((String)s).matches("#[a-fA-F\\d]{6}->#[a-fA-F\\d]{6}");
        }
    }
}

