/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay.compass;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import simpletextoverlay.overlay.compass.Pins;

public class DataManager {
    public static final String STO_DATA = "sto_data";
    private final Map<class_5321<class_1937>, Pins> worldPins = new HashMap<class_5321<class_1937>, Pins>();

    public class_2487 getSyncData() {
        class_2487 syncData = new class_2487();
        syncData.method_10566(STO_DATA, (class_2520)this.write());
        return syncData;
    }

    public void readSyncData(Optional<class_2487> nbt) {
        nbt.ifPresent(this::readSyncData);
    }

    public void readSyncData(class_2487 nbt) {
        Optional optionalListTag = nbt.method_10554(STO_DATA);
        optionalListTag.ifPresent(this::read);
    }

    public void read(class_2499 nbt) {
        for (int i = 0; i < nbt.size(); ++i) {
            class_2487 tag;
            Optional optionalCompoundTag = nbt.method_10602(i);
            if (!optionalCompoundTag.isPresent() || (tag = (class_2487)optionalCompoundTag.get()).method_10558("World").isEmpty()) continue;
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12838((String)((String)tag.method_10558("World").get()), (char)':'));
            class_5321 dimType = null;
            if (tag.method_10545("DimensionKey") && tag.method_10558("DimensionKey").isPresent()) {
                dimType = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)class_2960.method_12838((String)((String)tag.method_10558("DimensionKey").get()), (char)':'));
            }
            Pins pins = this.get((class_5321<class_1937>)key, dimType);
            if (!tag.method_10554("PINS").isPresent()) continue;
            pins.read((class_2499)tag.method_10554("PINS").get());
        }
    }

    public class_2499 write() {
        class_2499 list = new class_2499();
        for (Map.Entry<class_5321<class_1937>, Pins> entry : this.worldPins.entrySet()) {
            class_2487 tag = new class_2487();
            tag.method_10582("World", entry.getKey().method_29177().toString());
            if (entry.getValue().getDimensionTypeKey() != null) {
                tag.method_10582("DimensionKey", entry.getValue().getDimensionTypeKey().method_29177().toString());
            }
            tag.method_10566("PINS", (class_2520)entry.getValue().write());
            list.add((Object)tag);
        }
        return list;
    }

    public Pins get(class_1657 player) {
        return this.getInternal((class_5321<class_1937>)player.method_73183().method_27983(), () -> this.getDimensionTypeKey(player.method_73183(), null));
    }

    public Pins get(class_1657 player, class_5321<class_1937> worldKey) {
        return this.get(player, worldKey, null);
    }

    public Pins get(class_5321<class_1937> worldKey, @Nullable class_5321<class_2874> dimensionTypeKey) {
        return this.getInternal(worldKey, () -> dimensionTypeKey);
    }

    public Pins get(class_1657 player, class_5321<class_1937> worldKey, @Nullable class_5321<class_2874> dimensionTypeKey) {
        return this.getInternal(worldKey, () -> {
            if (player.method_73183().method_27983() == worldKey) {
                return this.getDimensionTypeKey(player.method_73183(), dimensionTypeKey);
            }
            MinecraftServer server = player.method_73183().method_8503();
            if (server == null) {
                return dimensionTypeKey;
            }
            class_3218 world = server.method_3847(worldKey);
            if (world == null) {
                return dimensionTypeKey;
            }
            return this.getDimensionTypeKey((class_1937)world, dimensionTypeKey);
        });
    }

    private Pins getInternal(class_5321<class_1937> worldKey, Supplier<class_5321<class_2874>> dimensionTypeKey) {
        return this.worldPins.computeIfAbsent(Objects.requireNonNull(worldKey), worldKey1 -> new Pins((class_5321<class_2874>)((class_5321)dimensionTypeKey.get())));
    }

    @Nullable
    private class_5321<class_2874> getDimensionTypeKey(class_1937 world, @Nullable class_5321<class_2874> fallback) {
        class_2874 dimType = world.method_8597();
        Optional optionalRegistry = world.method_30349().method_58561(class_7924.field_41241);
        if (optionalRegistry.isPresent()) {
            class_2960 key = ((class_2378)((class_6880.class_6883)optionalRegistry.get()).comp_349()).method_10221((Object)dimType);
            if (key == null) {
                return fallback;
            }
            return class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)key);
        }
        return fallback;
    }
}

