/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay;

import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import simpletextoverlay.config.OverlayConfig;
import simpletextoverlay.overlay.compass.DataManager;
import simpletextoverlay.overlay.compass.PinInfo;
import simpletextoverlay.platform.Services;
import simpletextoverlay.util.Alignment;
import simpletextoverlay.util.ColorHelper;
import simpletextoverlay.util.FontHelper;
import simpletextoverlay.util.VecMath;

public class HudCompass {
    public void renderText(class_332 guiGraphics, class_310 mc, int scaledWidth, int scaledHeight, float _partialTicks) {
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        float partialTicks = mc.method_1493() ? 0.0f : _partialTicks;
        double posX = class_3532.method_16436((double)partialTicks, (double)player.field_6014, (double)player.method_23317());
        double posY = class_3532.method_16436((double)partialTicks, (double)player.field_6036, (double)player.method_23318());
        double posZ = class_3532.method_16436((double)partialTicks, (double)player.field_5969, (double)player.method_23321());
        String compassText = "\u00b7";
        String worldSpawnText = "\u2299";
        String bedSpawnText = "\u2302";
        String lastDeathText = "\u2715";
        float yaw = class_3532.method_16439((float)partialTicks, (float)player.field_5982, (float)player.method_36454()) % 360.0f;
        int x = Alignment.getCompassX(scaledWidth, mc.field_1772.method_1727("\u00b7"));
        int y = Alignment.getCompassY();
        int bgColor = ColorHelper.rgb(0, 0, 0, OverlayConfig.getCompassOpacity());
        Objects.requireNonNull(mc.field_1772);
        guiGraphics.method_25294(x - 92, y - 1, x + 96, 9 + 2, bgColor);
        this.drawCardinal(mc, guiGraphics, yaw, 0.0f, x, y, "S");
        this.drawCardinal(mc, guiGraphics, yaw, 90.0f, x, y, "W");
        this.drawCardinal(mc, guiGraphics, yaw, 180.0f, x, y, "N");
        this.drawCardinal(mc, guiGraphics, yaw, 270.0f, x, y, "E");
        FontHelper.draw(mc, guiGraphics, "\u00b7", x, y, ColorHelper.decode("#b02e26").getRGB(), false, FontHelper.TextType.NONE);
        Services.CAPABILITY_PLATFORM.getDataManagerCapability((class_1657)player).ifPresent(arg_0 -> this.lambda$renderText$0((class_1657)player, posX, posY, posZ, mc, guiGraphics, yaw, x, y, arg_0));
    }

    private void drawCardinal(class_310 mc, class_332 guiGraphics, float yaw, float angle, int x, int y, String text) {
        this.drawInfo(mc, guiGraphics, yaw, angle, x, y, text, 1.0f, 1.0f, ColorHelper.decode("#FFFFFF").getRGB());
    }

    private void drawInfo(class_310 mc, class_332 guiGraphics, float yaw, float angle, int x, int y, String text, float size, float offset, int color) {
        class_4587 matrix = guiGraphics.method_51448();
        int aDist = (int)VecMath.angleDistance(yaw, angle);
        float scale = (float)OverlayConfig.scale();
        float resize = 1.0f / size;
        if ((float)Math.abs(aDist) <= 90.0f * offset) {
            int yPos;
            int xPos;
            if ((double)size == 1.0) {
                xPos = x + aDist;
                yPos = y;
            } else {
                xPos = (int)((float)x * resize) + aDist;
                yPos = (int)((float)y * resize);
            }
            if ((double)size != 1.0) {
                matrix.method_22903();
                matrix.method_22905(size, size, size);
            }
            FontHelper.draw(mc, guiGraphics, text, xPos, yPos, color, FontHelper.TextType.NONE);
            if ((double)size != 1.0) {
                matrix.method_22909();
                matrix.method_22905(scale, scale, scale);
            }
        }
    }

    private /* synthetic */ void lambda$renderText$0(class_1657 player, double posX, double posY, double posZ, class_310 mc, class_332 guiGraphics, float yaw, int x, int y, DataManager pinsData) {
        Map<String, PinInfo<?>> pins = pinsData.get(player).getPins();
        float offset = 0.5f;
        PinInfo<?> bedSpawn = pins.get("bedspawn");
        PinInfo<?> lastDeath = pins.get("lastdeath");
        PinInfo<?> worldSpawn = pins.get("worldspawn");
        if (bedSpawn != null) {
            class_241 bedSpawnAngle = VecMath.angleFromPos(bedSpawn.getPosition(), posX, posY, posZ);
            this.drawInfo(mc, guiGraphics, yaw, bedSpawnAngle.field_1343, x, y + 3, "\u2302", 0.5f, offset, ColorHelper.decode("#9c9d97").getRGB());
        }
        if (lastDeath != null) {
            class_241 lastDeathAngle = VecMath.angleFromPos(lastDeath.getPosition(), posX, posY, posZ);
            this.drawInfo(mc, guiGraphics, yaw, lastDeathAngle.field_1343, x, y, "\u2715", 0.5f, offset, ColorHelper.decode("#b02e26").getRGB());
        }
        if (worldSpawn != null) {
            class_241 worldSpawnAngle = VecMath.angleFromPos(worldSpawn.getPosition(), posX, posY, posZ);
            this.drawInfo(mc, guiGraphics, yaw, worldSpawnAngle.field_1343, x, y, "\u2299", 1.0f, offset, ColorHelper.decode("#5d7c15").getRGB());
        }
    }
}

