/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.util;

import java.awt.Color;
import simpletextoverlay.config.OverlayConfig;
import simpletextoverlay.util.SubSeason;

public class ColorHelper {
    public static int rgb(int r, int g, int b, int a) {
        return new Color(r, g, b, a).getRGB();
    }

    public static int getLightColor(int step) {
        Color bright = OverlayConfig.lightColorBright();
        Color dark = OverlayConfig.lightColorDark();
        return ColorHelper.getRangeColor(dark, bright, 16, step + 1);
    }

    public static int getTimeColor(long hour, long minute) {
        Color bright = OverlayConfig.timeColorBright();
        Color dark = OverlayConfig.timeColorDark();
        if (hour == 5L || hour == 18L) {
            if (hour == 5L) {
                return ColorHelper.getRangeColor(dark, bright, 60, (int)minute + 1);
            }
            return ColorHelper.getRangeColor(bright, dark, 60, (int)minute + 1);
        }
        if (hour < 5L || hour > 18L) {
            return dark.getRGB();
        }
        return bright.getRGB();
    }

    public static int getSeasonColor(SubSeason subSeason) {
        Color spring = ColorHelper.decode("#80c71f");
        Color summer = ColorHelper.decode("#ffd83d");
        Color fall = ColorHelper.decode("#f9801d");
        Color winter = ColorHelper.decode("#3ab3da");
        winter.getRGB();
        return switch (subSeason) {
            default -> throw new MatchException(null, null);
            case SubSeason.EARLY_SPRING -> ColorHelper.getRangeColor(winter, spring, 4, 3);
            case SubSeason.MID_SPRING -> ColorHelper.getRangeColor(winter, spring, 4, 4);
            case SubSeason.LATE_SPRING -> ColorHelper.getRangeColor(spring, summer, 4, 2);
            case SubSeason.EARLY_SUMMER -> ColorHelper.getRangeColor(spring, summer, 4, 3);
            case SubSeason.MID_SUMMER -> ColorHelper.getRangeColor(spring, summer, 4, 4);
            case SubSeason.LATE_SUMMER -> ColorHelper.getRangeColor(summer, fall, 4, 2);
            case SubSeason.EARLY_AUTUMN -> ColorHelper.getRangeColor(summer, fall, 4, 3);
            case SubSeason.MID_AUTUMN -> ColorHelper.getRangeColor(summer, fall, 4, 4);
            case SubSeason.LATE_AUTUMN -> ColorHelper.getRangeColor(fall, winter, 4, 2);
            case SubSeason.EARLY_WINTER -> ColorHelper.getRangeColor(fall, winter, 4, 3);
            case SubSeason.MID_WINTER -> ColorHelper.getRangeColor(fall, winter, 4, 4);
            case SubSeason.LATE_WINTER -> ColorHelper.getRangeColor(winter, spring, 4, 2);
        };
    }

    public static Color decode(String color) {
        return Color.decode(color);
    }

    private static int getRangeColor(Color from, Color to, int steps, int step) {
        int diffRed = to.getRed() - from.getRed();
        int diffGreen = to.getGreen() - from.getGreen();
        int diffBlue = to.getBlue() - from.getBlue();
        return new Color(from.getRed() + diffRed * step / steps, from.getGreen() + diffGreen * step / steps, from.getBlue() + diffBlue * step / steps).getRGB();
    }
}

