/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.events;

import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import simpletextoverlay.overlay.compass.Pin;
import simpletextoverlay.overlay.compass.PinInfo;
import simpletextoverlay.platform.Services;
import simpletextoverlay.util.PinHelper;

public class SimpleTextOverlayEvents {
    public static void onEntityJoinLevel(Player player) {
        if (player != null && !player.level().isClientSide()) {
            ServerPlayer sp = (ServerPlayer)player;
            SimpleTextOverlayEvents.initPins(sp);
        }
    }

    public static void onPlayerChangeDimension(Player player, ResourceKey<Level> worldKey) {
        if (!player.level().isClientSide()) {
            ServerPlayer sp = (ServerPlayer)player;
            if (!worldKey.location().toString().contains(BuiltinDimensionTypes.OVERWORLD.location().toString())) {
                Services.CAPABILITY_PLATFORM.getDataManagerCapability((Player)sp).ifPresent(pinsData -> {
                    BlockPos spawnPos = new BlockPos((int)sp.getX(), (int)sp.getY(), (int)sp.getZ());
                    PinHelper.setPointPin((Player)sp, pinsData, worldKey, spawnPos, Pin.PinType.WORLDSPAWN);
                    Services.CAPABILITY_PLATFORM.syncData(sp);
                });
            } else {
                SimpleTextOverlayEvents.initPins(sp);
            }
        }
    }

    public static void initPins(ServerPlayer sp) {
        Services.CAPABILITY_PLATFORM.getDataManagerCapability((Player)sp).ifPresent(pinsData -> {
            ResourceKey worldKey = sp.level().dimension();
            Optional lastDeathLocation = sp.getLastDeathLocation();
            Map<String, PinInfo<?>> pins = pinsData.get((Player)sp).getPins();
            PinInfo<?> worldSpawn = pins.get(Pin.PinType.WORLDSPAWN.toString());
            ServerPlayer.RespawnConfig respawnConfig = sp.getRespawnConfig();
            if (worldSpawn == null && worldKey.location().toString().contains(BuiltinDimensionTypes.OVERWORLD.location().toString())) {
                BlockPos spawnPos = sp.level().getServer().getWorldData().overworldData().getRespawnData().pos();
                PinHelper.setPointPin((Player)sp, pinsData, (ResourceKey<Level>)worldKey, spawnPos, Pin.PinType.WORLDSPAWN);
            }
            if (respawnConfig != null) {
                PinHelper.setPointPin((Player)sp, pinsData, (ResourceKey<Level>)respawnConfig.respawnData().dimension(), respawnConfig.respawnData().pos(), Pin.PinType.BEDSPAWN);
            }
            lastDeathLocation.ifPresent(globalPos -> PinHelper.setPointPin((Player)sp, pinsData, (ResourceKey<Level>)globalPos.dimension(), globalPos.pos(), Pin.PinType.LASTDEATH));
            Services.CAPABILITY_PLATFORM.syncData(sp);
        });
    }
}

