/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay;

import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import simpletextoverlay.config.OverlayConfig;
import simpletextoverlay.overlay.Info;
import simpletextoverlay.util.Alignment;
import simpletextoverlay.util.FontHelper;

public class BiomeInfo
extends Info {
    public BiomeInfo(String label, int lineNum) {
        super(label, lineNum);
    }

    @Override
    public void renderText(GuiGraphics guiGraphics, Minecraft mc, BlockPos pos, int scaledWidth, int scaledHeight) {
        Holder biome = Objects.requireNonNull(mc.level).getBiome(pos);
        biome.unwrapKey().ifPresent(key -> {
            MutableComponent biomeName = Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)key.location()));
            int x = Alignment.getX(scaledWidth, mc.font.width(this.label) + mc.font.width((FormattedText)biomeName));
            Objects.requireNonNull(mc.font);
            int y = Alignment.getY(scaledHeight, this.lineNum, 9);
            FontHelper.draw(mc, guiGraphics, this.label, x, y, OverlayConfig.labelColor().getRGB(), FontHelper.TextType.LABEL);
            FontHelper.draw(mc, guiGraphics, (Component)biomeName, x += mc.font.width(this.label), y, OverlayConfig.biomeColor().getRGB(), FontHelper.TextType.VALUE);
        });
    }
}

