/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import simpletextoverlay.config.OverlayConfig;
import simpletextoverlay.overlay.Info;
import simpletextoverlay.util.Alignment;
import simpletextoverlay.util.ColorHelper;
import simpletextoverlay.util.FontHelper;

public class LightInfo
extends Info {
    public LightInfo(String label, int lineNum) {
        super(label, lineNum);
    }

    @Override
    public void renderText(GuiGraphics guiGraphics, Minecraft mc, BlockPos pos, int scaledWidth, int scaledHeight) {
        Level level = Objects.requireNonNull(mc.getCameraEntity()).level();
        if (level.dimensionType().hasSkyLight()) {
            int blockLight = level.getChunkSource().getLightEngine().getRawBrightness(pos.above(), 15);
            int i = level.getBrightness(LightLayer.SKY, pos.above()) - level.getSkyDarken();
            float f = level.getSunAngle(1.0f);
            if (i > 0) {
                float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
                f += (f1 - f) * 0.2f;
                i = Math.round((float)i * Mth.cos((float)f));
            }
            int skyLight = Mth.clamp((int)i, (int)0, (int)15);
            if (level.isRainingAt(pos)) {
                skyLight = level.isThundering() ? (skyLight -= 3) : (skyLight -= 2);
            }
            int brightnessVal = Math.max(blockLight, skyLight);
            String brightness = String.valueOf(brightnessVal);
            int x = Alignment.getX(scaledWidth, mc.font.width(this.label + brightness));
            Objects.requireNonNull(mc.font);
            int y = Alignment.getY(scaledHeight, this.lineNum, 9);
            FontHelper.draw(mc, guiGraphics, this.label, x, y, OverlayConfig.labelColor().getRGB(), FontHelper.TextType.LABEL);
            FontHelper.draw(mc, guiGraphics, brightness, x += mc.font.width(this.label), y, ColorHelper.getLightColor(brightnessVal), FontHelper.TextType.VALUE);
        }
    }
}

