/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay.compass;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.Nullable;
import simpletextoverlay.overlay.compass.PinInfo;
import simpletextoverlay.overlay.compass.PinInfoRegistry;

public class Pins {
    @Nullable
    private final ResourceKey<DimensionType> dimensionTypeKey;
    private final Map<String, PinInfo<?>> pins = new HashMap();

    public Pins(@Nullable ResourceKey<DimensionType> dimensionTypeKey) {
        this.dimensionTypeKey = dimensionTypeKey;
    }

    public Map<String, PinInfo<?>> getPins() {
        return this.pins;
    }

    public void read(ListTag nbt) {
        for (int i = 0; i < nbt.size(); ++i) {
            Optional optionalTag = nbt.getCompound(i);
            if (!optionalTag.isPresent()) continue;
            PinInfo<?> pin = PinInfoRegistry.deserializePin((CompoundTag)optionalTag.get());
            this.pins.put(pin.getInternalId(), pin);
        }
    }

    public ListTag write() {
        ListTag tag = new ListTag();
        for (PinInfo<?> pin : this.pins.values()) {
            tag.add((Object)PinInfoRegistry.serializePin(pin));
        }
        return tag;
    }

    public void addPin(PinInfo<?> pin) {
        this.pins.put(pin.getInternalId(), pin);
    }

    public void removePin(PinInfo<?> pin) {
        this.removePin(pin.getInternalId());
    }

    public void removePin(String id) {
        PinInfo<?> pin = this.pins.get(id);
        if (pin != null) {
            this.pins.remove(pin.getInternalId());
        }
    }

    @Nullable
    public ResourceKey<DimensionType> getDimensionTypeKey() {
        return this.dimensionTypeKey;
    }
}

