/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.platform;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import simpletextoverlay.platform.Services;
import simpletextoverlay.platform.services.ISeasonInfo;
import simpletextoverlay.util.EclipticSeasonsHelper;
import simpletextoverlay.util.SereneSeasonsNeoForgeHelper;
import simpletextoverlay.util.SubSeason;

public class NeoForgeSeasonInfo
implements ISeasonInfo {
    @Override
    public Pair<Component, SubSeason> getSeasonName(Level level, BlockPos pos) {
        boolean hasSeasonDimension = false;
        SubSeason subSeason = SubSeason.MID_SPRING;
        if (Services.PLATFORM.isModLoaded("sereneseasons")) {
            subSeason = SereneSeasonsNeoForgeHelper.getSubSeason(level);
            hasSeasonDimension = SereneSeasonsNeoForgeHelper.isDimensionWhitelisted((ResourceKey<Level>)level.dimension());
        } else if (Services.PLATFORM.isModLoaded("eclipticseasons") && (hasSeasonDimension = EclipticSeasonsHelper.isSeasonDimension(level))) {
            subSeason = EclipticSeasonsHelper.getSubSeason(level);
        }
        if (hasSeasonDimension) {
            MutableComponent seasonName = Component.translatable((String)("desc.simpletextoverlay." + subSeason.name().toLowerCase()));
            return Pair.of((Object)seasonName, (Object)((Object)subSeason));
        }
        return null;
    }
}

