/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay;

import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix3x2fStack;
import simpletextoverlay.config.OverlayConfig;
import simpletextoverlay.overlay.compass.DataManager;
import simpletextoverlay.overlay.compass.Pin;
import simpletextoverlay.overlay.compass.PinInfo;
import simpletextoverlay.platform.Services;
import simpletextoverlay.util.Alignment;
import simpletextoverlay.util.ColorHelper;
import simpletextoverlay.util.FontHelper;
import simpletextoverlay.util.VecMath;

public class HudCompass {
    public void renderText(GuiGraphics guiGraphics, Minecraft mc, int scaledWidth, float _partialTicks) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        float partialTicks = mc.isPaused() ? 0.0f : _partialTicks;
        double posX = player.getX();
        double posY = player.getY();
        double posZ = player.getZ();
        String compassText = "\u00b7";
        String worldSpawnText = "\u2299";
        String bedSpawnText = "\u2302";
        String lastDeathText = "\u2715";
        float yaw = Mth.lerp((float)partialTicks, (float)player.yRotO, (float)player.getYRot()) % 360.0f;
        int x = Alignment.getCompassX(scaledWidth, mc.font.width("\u00b7"));
        int y = Alignment.getCompassY();
        int bgColor = ColorHelper.rgb(0, 0, 0, OverlayConfig.getCompassOpacity());
        Objects.requireNonNull(mc.font);
        guiGraphics.fill(x - 92, y - 1, x + 96, 9 + 2, bgColor);
        this.drawCardinal(mc, guiGraphics, yaw, 0.0f, x, y, "S");
        this.drawCardinal(mc, guiGraphics, yaw, 90.0f, x, y, "W");
        this.drawCardinal(mc, guiGraphics, yaw, 180.0f, x, y, "N");
        this.drawCardinal(mc, guiGraphics, yaw, 270.0f, x, y, "E");
        FontHelper.draw(mc, guiGraphics, "\u00b7", x, y, ColorHelper.decode("#b02e26").getRGB(), false, FontHelper.TextType.NONE);
        Services.CAPABILITY_PLATFORM.getDataManagerCapability((Player)player).ifPresent(arg_0 -> this.lambda$renderText$0((Player)player, posX, posY, posZ, mc, guiGraphics, yaw, x, y, arg_0));
    }

    private void drawCardinal(Minecraft mc, GuiGraphics guiGraphics, float yaw, float angle, int x, int y, String text) {
        this.drawInfo(mc, guiGraphics, yaw, angle, x, y, text, 1.0f, 1.0f, ColorHelper.decode("#FFFFFF").getRGB());
    }

    private void drawInfo(Minecraft mc, GuiGraphics guiGraphics, float yaw, float angle, int x, int y, String text, float size, float offset, int color) {
        Matrix3x2fStack matrix = guiGraphics.pose();
        int aDist = (int)VecMath.angleDistance(yaw, angle);
        float scale = (float)OverlayConfig.scale();
        float resize = 1.0f / size;
        if ((float)Math.abs(aDist) <= 90.0f * offset) {
            int yPos;
            int xPos;
            if ((double)size == 1.0) {
                xPos = x + aDist;
                yPos = y;
            } else {
                xPos = (int)((float)x * resize) + aDist;
                yPos = (int)((float)y * resize);
            }
            if ((double)size != 1.0) {
                matrix.pushMatrix();
                matrix.scale(size, size);
            }
            FontHelper.draw(mc, guiGraphics, text, xPos, yPos, color, FontHelper.TextType.NONE);
            if ((double)size != 1.0) {
                matrix.popMatrix();
                matrix.scale(scale, scale);
            }
        }
    }

    private /* synthetic */ void lambda$renderText$0(Player player, double posX, double posY, double posZ, Minecraft mc, GuiGraphics guiGraphics, float yaw, int x, int y, DataManager pinsData) {
        Map<String, PinInfo<?>> pins = pinsData.get(player).getPins();
        float offset = 0.5f;
        PinInfo<?> bedSpawn = pins.get(Pin.PinType.BEDSPAWN.toString());
        PinInfo<?> lastDeath = pins.get(Pin.PinType.LASTDEATH.toString());
        PinInfo<?> worldSpawn = pins.get(Pin.PinType.WORLDSPAWN.toString());
        if (bedSpawn != null) {
            Vec2 bedSpawnAngle = VecMath.angleFromPos(bedSpawn.getPosition(), posX, posY, posZ);
            this.drawInfo(mc, guiGraphics, yaw, bedSpawnAngle.x, x, y + 3, "\u2302", 0.5f, offset, ColorHelper.decode("#9c9d97").getRGB());
        }
        if (lastDeath != null) {
            Vec2 lastDeathAngle = VecMath.angleFromPos(lastDeath.getPosition(), posX, posY, posZ);
            this.drawInfo(mc, guiGraphics, yaw, lastDeathAngle.x, x, y, "\u2715", 0.5f, offset, ColorHelper.decode("#b02e26").getRGB());
        }
        if (worldSpawn != null) {
            Vec2 worldSpawnAngle = VecMath.angleFromPos(worldSpawn.getPosition(), posX, posY, posZ);
            this.drawInfo(mc, guiGraphics, yaw, worldSpawnAngle.x, x, y, "\u2299", 1.0f, offset, ColorHelper.decode("#5d7c15").getRGB());
        }
    }
}

