/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay.compass;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.Nullable;
import simpletextoverlay.overlay.compass.Pins;

public class DataManager {
    public static final String STO_DATA = "sto_data";
    private final Map<ResourceKey<Level>, Pins> worldPins = new HashMap<ResourceKey<Level>, Pins>();

    public CompoundTag getSyncData() {
        CompoundTag syncData = new CompoundTag();
        syncData.put(STO_DATA, (Tag)this.write());
        return syncData;
    }

    public void readSyncData(Optional<CompoundTag> nbt) {
        nbt.ifPresent(this::readSyncData);
    }

    public void readSyncData(CompoundTag nbt) {
        Optional optionalListTag = nbt.getList(STO_DATA);
        optionalListTag.ifPresent(this::read);
    }

    public void read(ListTag nbt) {
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag tag;
            Optional optionalCompoundTag = nbt.getCompound(i);
            if (!optionalCompoundTag.isPresent() || (tag = (CompoundTag)optionalCompoundTag.get()).getString("World").isEmpty()) continue;
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.bySeparator((String)((String)tag.getString("World").get()), (char)':'));
            ResourceKey dimType = null;
            if (tag.contains("DimensionKey") && tag.getString("DimensionKey").isPresent()) {
                dimType = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.bySeparator((String)((String)tag.getString("DimensionKey").get()), (char)':'));
            }
            Pins pins = this.get((ResourceKey<Level>)key, dimType);
            if (!tag.getList("PINS").isPresent()) continue;
            pins.read((ListTag)tag.getList("PINS").get());
        }
    }

    public ListTag write() {
        ListTag list = new ListTag();
        for (Map.Entry<ResourceKey<Level>, Pins> entry : this.worldPins.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.putString("World", entry.getKey().location().toString());
            if (entry.getValue().getDimensionTypeKey() != null) {
                tag.putString("DimensionKey", entry.getValue().getDimensionTypeKey().location().toString());
            }
            tag.put("PINS", (Tag)entry.getValue().write());
            list.add((Object)tag);
        }
        return list;
    }

    public Pins get(Player player) {
        return this.getInternal((ResourceKey<Level>)player.level().dimension(), () -> this.getDimensionTypeKey(player.level(), null));
    }

    public Pins get(Player player, ResourceKey<Level> worldKey) {
        return this.get(player, worldKey, null);
    }

    public Pins get(ResourceKey<Level> worldKey, @Nullable ResourceKey<DimensionType> dimensionTypeKey) {
        return this.getInternal(worldKey, () -> dimensionTypeKey);
    }

    public Pins get(Player player, ResourceKey<Level> worldKey, @Nullable ResourceKey<DimensionType> dimensionTypeKey) {
        return this.getInternal(worldKey, () -> {
            if (player.level().dimension() == worldKey) {
                return this.getDimensionTypeKey(player.level(), dimensionTypeKey);
            }
            MinecraftServer server = player.level().getServer();
            if (server == null) {
                return dimensionTypeKey;
            }
            ServerLevel world = server.getLevel(worldKey);
            if (world == null) {
                return dimensionTypeKey;
            }
            return this.getDimensionTypeKey((Level)world, dimensionTypeKey);
        });
    }

    private Pins getInternal(ResourceKey<Level> worldKey, Supplier<ResourceKey<DimensionType>> dimensionTypeKey) {
        return this.worldPins.computeIfAbsent(Objects.requireNonNull(worldKey), worldKey1 -> new Pins((ResourceKey<DimensionType>)((ResourceKey)dimensionTypeKey.get())));
    }

    @Nullable
    private ResourceKey<DimensionType> getDimensionTypeKey(Level world, @Nullable ResourceKey<DimensionType> fallback) {
        DimensionType dimType = world.dimensionType();
        Optional optionalRegistry = world.registryAccess().get(Registries.DIMENSION_TYPE);
        if (optionalRegistry.isPresent()) {
            ResourceLocation key = ((Registry)((Holder.Reference)optionalRegistry.get()).value()).getKey((Object)dimType);
            if (key == null) {
                return fallback;
            }
            return ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)key);
        }
        return fallback;
    }
}

