/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay.compass;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import simpletextoverlay.overlay.compass.PinInfo;
import simpletextoverlay.overlay.compass.PinInfoRegistry;
import simpletextoverlay.overlay.compass.PinInfoType;

public class Pin
extends PinInfo<Pin> {
    private Vec3 position;

    public Pin() {
        super(PinInfoRegistry.TYPE, PinType.NONE.toString());
    }

    public Pin(PinInfoType<? extends Pin> type, Vec3 exactPosition, PinType id) {
        super(type, id.toString());
        this.position = exactPosition;
    }

    @Override
    public Vec3 getPosition() {
        return this.position;
    }

    @Override
    protected void serializeAdditional(CompoundTag tag) {
        tag.putDouble("X", this.position.x);
        tag.putDouble("Y", this.position.y);
        tag.putDouble("Z", this.position.z);
    }

    @Override
    protected void deserializeAdditional(CompoundTag tag) {
        if (tag.getDouble("X").isPresent() && tag.getDouble("Y").isPresent() && tag.getDouble("Z").isPresent()) {
            double x = (Double)tag.getDouble("X").get();
            double y = (Double)tag.getDouble("Y").get();
            double z = (Double)tag.getDouble("Z").get();
            this.position = new Vec3(x, y, z);
        }
    }

    @Override
    protected void serializeAdditional(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.position.x);
        buffer.writeDouble(this.position.y);
        buffer.writeDouble(this.position.z);
    }

    @Override
    protected void deserializeAdditional(FriendlyByteBuf buffer) {
        this.position = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static enum PinType {
        BEDSPAWN,
        LASTDEATH,
        NONE,
        WORLDSPAWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

