/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.overlay.compass;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import simpletextoverlay.overlay.compass.Pin;
import simpletextoverlay.overlay.compass.PinInfo;
import simpletextoverlay.overlay.compass.PinInfoType;

public class PinInfoRegistry {
    public static final BiMap<ResourceLocation, PinInfoType<?>> typesMap = HashBiMap.create();
    public static final BiMap<Integer, PinInfoType<?>> idsMap = HashBiMap.create();
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"simpletextoverlay", (String)"pin");
    public static PinInfoType<Pin> TYPE = new PinInfoType<Pin>(Pin::new, LOCATION);

    public static void init() {
    }

    public static CompoundTag serializePin(@NotNull PinInfo<?> pinData) {
        PinInfoType<?> type = pinData.getType();
        ResourceLocation typeId = type.getName();
        if (typeId == null) {
            throw new IllegalStateException(String.format("Serializer name is null %s", type.getClass().getName()));
        }
        CompoundTag tag = new CompoundTag();
        tag.putString("PinType", type.getName().toString());
        return pinData.write(tag);
    }

    @NotNull
    public static PinInfo<?> deserializePin(CompoundTag tag) {
        if (tag.getString("PinType").isPresent()) {
            ResourceLocation typeId = ResourceLocation.bySeparator((String)((String)tag.getString("PinType").get()), (char)':');
            PinInfoType type = (PinInfoType)typesMap.get((Object)typeId);
            if (type == null) {
                throw new IllegalStateException(String.format("Serializer not registered %s", typeId));
            }
            Object info = type.create();
            ((PinInfo)info).read(tag);
            return info;
        }
        throw new IllegalStateException("Pin type not specified in tag");
    }

    public static void serializePin(PinInfo<?> pinData, FriendlyByteBuf buffer) {
        PinInfoType<?> type = pinData.getType();
        int id = (Integer)idsMap.inverse().get(type);
        buffer.writeVarInt(id);
        pinData.writeToPacket(buffer);
    }

    @NotNull
    public static PinInfo<?> deserializePin(FriendlyByteBuf buffer) {
        int id = buffer.readVarInt();
        PinInfoType serializer = (PinInfoType)idsMap.get((Object)id);
        if (serializer == null) {
            throw new IllegalStateException("Server returned unknown serializer");
        }
        Object info = serializer.create();
        ((PinInfo)info).readFromPacket(buffer);
        return info;
    }

    static {
        typesMap.put((Object)LOCATION, TYPE);
        idsMap.put((Object)1, TYPE);
    }
}

