/*
 * Decompiled with CFR 0.152.
 */
package simpletextoverlay.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.ARGB;
import simpletextoverlay.config.OverlayConfig;

public class FontHelper {
    public static void draw(Minecraft mc, GuiGraphics guiGraphics, Component label, int x, int y, int color, TextType textType) {
        FontHelper.drawBackdrop(mc, guiGraphics, mc.font.width((FormattedText)label), x, y, color, textType);
        guiGraphics.drawString(mc.font, label, x, y, color, OverlayConfig.textShadow());
    }

    public static void draw(Minecraft mc, GuiGraphics guiGraphics, String label, int x, int y, int color, TextType textType) {
        FontHelper.draw(mc, guiGraphics, label, x, y, color, OverlayConfig.textShadow(), textType);
    }

    public static void draw(Minecraft mc, GuiGraphics guiGraphics, String label, int x, int y, int color, boolean shadow, TextType textType) {
        FontHelper.drawBackdrop(mc, guiGraphics, mc.font.width(label), x, y, color, textType);
        guiGraphics.drawString(mc.font, label, x, y, color, shadow);
    }

    private static void drawBackdrop(Minecraft mc, GuiGraphics guiGraphics, int textWidth, int x, int y, int color, TextType textType) {
        int backgroundColor;
        int leftOffset = 2;
        int rightOffset = 2;
        switch (textType.ordinal()) {
            case 1: {
                rightOffset = 0;
                break;
            }
            case 2: {
                leftOffset = 0;
            }
        }
        if (textWidth != 0 && !((Boolean)mc.options.backgroundForChatOnly().get()).booleanValue() && (backgroundColor = mc.options.getBackgroundColor(0)) != 0) {
            guiGraphics.fill(x - leftOffset, y - 1, x + textWidth + rightOffset, y + 7 + 2, ARGB.multiply((int)backgroundColor, (int)color));
        }
    }

    public static enum TextType {
        NONE,
        LABEL,
        VALUE;

    }
}

