/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.client;

import dev.foxgirl.pickaxetrims.shared.PickaxeTrim;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PickaxeTrimModels {
    private static final ModelResourceLocation[] MODEL_IDS = new ModelResourceLocation[PickaxeTrim.PickaxeType.COUNT * PickaxeTrim.TrimType.COUNT];

    private static int calculateIndex(PickaxeTrim.PickaxeType pickaxeType, PickaxeTrim.TrimType trimType) {
        return pickaxeType.ordinal() * PickaxeTrim.TrimType.COUNT + trimType.ordinal();
    }

    @NotNull
    public static ModelResourceLocation getModelID(@NotNull PickaxeTrim.PickaxeType pickaxeType, @NotNull PickaxeTrim.TrimType trimType) {
        return MODEL_IDS[PickaxeTrimModels.calculateIndex(pickaxeType, trimType)];
    }

    @Nullable
    public static ModelResourceLocation getModelID(@NotNull ItemStack stack) {
        PickaxeTrim.PickaxeType pickaxeType = PickaxeTrim.getPickaxeType(stack);
        if (pickaxeType == null) {
            return null;
        }
        PickaxeTrim.TrimType trimType = PickaxeTrim.getTrimType(stack);
        if (trimType == null) {
            return null;
        }
        return PickaxeTrimModels.getModelID(pickaxeType, trimType);
    }

    @NotNull
    public static List<ModelResourceLocation> getModelIDs() {
        return Arrays.asList(MODEL_IDS);
    }

    static {
        for (PickaxeTrim.PickaxeType pickaxeType : PickaxeTrim.PickaxeType.VALUES) {
            for (PickaxeTrim.TrimType trimType : PickaxeTrim.TrimType.VALUES) {
                ModelResourceLocation modelInventoryID;
                ResourceLocation baseID = ResourceLocation.fromNamespaceAndPath((String)"pickaxetrims", (String)(String.valueOf((Object)pickaxeType) + "_trimmed_" + String.valueOf((Object)trimType)));
                PickaxeTrimModels.MODEL_IDS[PickaxeTrimModels.calculateIndex((PickaxeTrim.PickaxeType)pickaxeType, (PickaxeTrim.TrimType)trimType)] = modelInventoryID = ModelResourceLocation.inventory((ResourceLocation)baseID);
            }
        }
    }
}

