/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrimsImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PickaxeTrim(@NotNull Holder<Item> ingredient, boolean showInTooltip) implements TooltipProvider
{
    @NotNull
    public static final Codec<PickaxeTrim> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryFixedCodec.create((ResourceKey)Registries.ITEM).fieldOf("ingredient").forGetter(PickaxeTrim::ingredient), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(PickaxeTrim::showInTooltip)).apply((Applicative)instance, PickaxeTrim::new));
    @NotNull
    public static final StreamCodec<RegistryFriendlyByteBuf, PickaxeTrim> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM), PickaxeTrim::ingredient, (StreamCodec)ByteBufCodecs.BOOL, PickaxeTrim::showInTooltip, PickaxeTrim::new);
    private static final Component UPGRADE_TEXT = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"smithing_template.upgrade"))).withStyle(ChatFormatting.GRAY);

    @Nullable
    public TrimType trimType() {
        return TrimType.from((Item)this.ingredient.value());
    }

    @Nullable
    public static PickaxeTrim get(@NotNull ItemStack stack) {
        return (PickaxeTrim)stack.get(PickaxeTrimsImpl.getInstance().getTrimComponentType());
    }

    @NotNull
    public static ItemStack set(@NotNull ItemStack stack, @NotNull PickaxeTrim trim) {
        stack.set(PickaxeTrimsImpl.getInstance().getTrimComponentType(), (Object)trim);
        return stack;
    }

    @NotNull
    public static ItemStack set(@NotNull ItemStack stack, @NotNull TrimType trimType) {
        return PickaxeTrim.set(stack, new PickaxeTrim((Holder<Item>)Holder.direct((Object)trimType.getItem()), true));
    }

    @Nullable
    public static PickaxeType getPickaxeType(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return PickaxeType.from(stack.getItem());
    }

    @Nullable
    public static TrimType getTrimType(@Nullable ItemStack stack) {
        PickaxeTrim trim;
        if (stack != null && (trim = PickaxeTrim.get(stack)) != null) {
            return trim.trimType();
        }
        return null;
    }

    public static boolean isOfTrimType(@Nullable ItemStack stack, @NotNull TrimType trimType) {
        return PickaxeTrim.getTrimType(stack) == trimType;
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type) {
        TrimType trimType;
        if (this.showInTooltip && (trimType = this.trimType()) != null) {
            tooltip.accept(UPGRADE_TEXT);
            tooltip.accept((Component)CommonComponents.space().append(trimType.getMaterialText()));
            tooltip.accept((Component)CommonComponents.space().append(trimType.getDescriptionText()));
        }
    }

    public static enum TrimType {
        CRYING_OBSIDIAN{

            @NotNull
            public String toString() {
                return "crying_obsidian";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.CRYING_OBSIDIAN;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.DARK_PURPLE;
            }
        }
        ,
        LAPIS_LAZULI{

            @NotNull
            public String toString() {
                return "lapis_lazuli";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.LAPIS_LAZULI;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.BLUE;
            }
        }
        ,
        EMERALD{

            @NotNull
            public String toString() {
                return "emerald";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.EMERALD;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.GREEN;
            }
        }
        ,
        QUARTZ{

            @NotNull
            public String toString() {
                return "quartz";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.QUARTZ;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.WHITE;
            }
        }
        ,
        REDSTONE{

            @NotNull
            public String toString() {
                return "redstone";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.REDSTONE;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.RED;
            }
        }
        ,
        COPPER{

            @NotNull
            public String toString() {
                return "copper";
            }

            @Override
            @NotNull
            public Item getItem() {
                return Items.COPPER_INGOT;
            }

            @Override
            @NotNull
            public ChatFormatting getColor() {
                return ChatFormatting.GOLD;
            }
        };

        @NotNull
        public static final List<TrimType> VALUES;
        public static final int COUNT;
        @NotNull
        private static final Map<String, TrimType> BY_NAME;

        @Nullable
        public static TrimType parse(@Nullable String name) {
            return BY_NAME.get(name);
        }

        @Nullable
        public static TrimType from(@NotNull Item item) {
            if (item == Items.CRYING_OBSIDIAN) {
                return CRYING_OBSIDIAN;
            }
            if (item == Items.LAPIS_LAZULI) {
                return LAPIS_LAZULI;
            }
            if (item == Items.EMERALD) {
                return EMERALD;
            }
            if (item == Items.QUARTZ) {
                return QUARTZ;
            }
            if (item == Items.REDSTONE) {
                return REDSTONE;
            }
            if (item == Items.COPPER_INGOT) {
                return COPPER;
            }
            return null;
        }

        @NotNull
        public abstract Item getItem();

        @NotNull
        public abstract ChatFormatting getColor();

        @NotNull
        public Component getMaterialText() {
            return Component.translatable((String)("pickaxetrims.material." + String.valueOf((Object)this))).withStyle(this.getColor());
        }

        @NotNull
        public Component getDescriptionText() {
            return Component.translatable((String)("pickaxetrims.description." + String.valueOf((Object)this))).withStyle(this.getColor());
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])TrimType.values());
            COUNT = VALUES.size();
            BY_NAME = (Map)Util.make(new HashMap(), map -> {
                for (TrimType type : VALUES) {
                    map.put(type.toString(), type);
                }
            });
        }
    }

    public static enum PickaxeType {
        NETHERITE,
        DIAMOND,
        GOLD,
        IRON;

        @NotNull
        public static final List<PickaxeType> VALUES;
        public static final int COUNT;

        @Nullable
        private static PickaxeType from(@NotNull Item item) {
            if (item == Items.NETHERITE_PICKAXE) {
                return NETHERITE;
            }
            if (item == Items.DIAMOND_PICKAXE) {
                return DIAMOND;
            }
            if (item == Items.GOLDEN_PICKAXE) {
                return GOLD;
            }
            if (item == Items.IRON_PICKAXE) {
                return IRON;
            }
            return null;
        }

        @NotNull
        public Item getItem() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Items.NETHERITE_PICKAXE;
                case 1 -> Items.DIAMOND_PICKAXE;
                case 2 -> Items.GOLDEN_PICKAXE;
                case 3 -> Items.IRON_PICKAXE;
            };
        }

        @NotNull
        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "netherite_pickaxe";
                case 1 -> "diamond_pickaxe";
                case 2 -> "gold_pickaxe";
                case 3 -> "iron_pickaxe";
            };
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])PickaxeType.values());
            COUNT = VALUES.size();
        }
    }
}

