/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.value.IntValue;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrim;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrimsConfig;
import dev.foxgirl.pickaxetrims.shared.effect.CryingObsidianMultiBreakEffect;
import dev.foxgirl.pickaxetrims.shared.effect.LapisGlowEffect;
import dev.foxgirl.pickaxetrims.shared.effect.RedstoneVeinMineEffect;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PickaxeTrimsImpl
implements TickEvent.Server,
BlockEvent.Break,
LootEvent.ModifyLootTable {
    private static PickaxeTrimsImpl INSTANCE;
    @NotNull
    public final PickaxeTrimsConfig config;
    @NotNull
    private final DeferredRegister<DataComponentType<?>> registryComponentType;
    @NotNull
    private final DeferredRegister<Item> registryItem;
    @NotNull
    private final DeferredRegister<CreativeModeTab> registryItemGroup;
    @NotNull
    private final @NotNull RegistrySupplier<@NotNull DataComponentType<PickaxeTrim>> trimComponentType;
    @NotNull
    private final @NotNull RegistrySupplier<@NotNull SmithingTemplateItem> smithingTemplateItem;
    @NotNull
    private final @NotNull RegistrySupplier<@NotNull CreativeModeTab> itemGroup;
    private CryingObsidianMultiBreakEffect cryingObsidianEffect;
    private RedstoneVeinMineEffect redstoneEffect;
    private LapisGlowEffect lapisEffect;

    public static PickaxeTrimsImpl getInstance() {
        return INSTANCE;
    }

    @NotNull
    public DataComponentType<PickaxeTrim> getTrimComponentType() {
        return (DataComponentType)this.trimComponentType.get();
    }

    @NotNull
    public SmithingTemplateItem getSmithingTemplateItem() {
        return (SmithingTemplateItem)this.smithingTemplateItem.get();
    }

    @NotNull
    public CreativeModeTab getItemGroup() {
        return (CreativeModeTab)this.itemGroup.get();
    }

    @NotNull
    public ResourceKey<CreativeModeTab> getItemGroupKey() {
        return ResourceKey.create((ResourceKey)this.itemGroup.getRegistryKey(), (ResourceLocation)this.itemGroup.getId());
    }

    public PickaxeTrimsImpl() {
        INSTANCE = this;
        this.config = PickaxeTrimsConfig.loadConfig();
        this.registryComponentType = DeferredRegister.create((String)"pickaxetrims", (ResourceKey)Registries.DATA_COMPONENT_TYPE);
        this.registryItem = DeferredRegister.create((String)"pickaxetrims", (ResourceKey)Registries.ITEM);
        this.registryItemGroup = DeferredRegister.create((String)"pickaxetrims", (ResourceKey)Registries.CREATIVE_MODE_TAB);
        this.trimComponentType = this.registryComponentType.register(ResourceLocation.fromNamespaceAndPath((String)"pickaxetrims", (String)"trim"), () -> DataComponentType.builder().persistent(PickaxeTrim.CODEC).networkSynchronized(PickaxeTrim.PACKET_CODEC).cacheEncoding().build());
        this.smithingTemplateItem = this.registryItem.register(ResourceLocation.fromNamespaceAndPath((String)"pickaxetrims", (String)"fracture_armor_trim_smithing_template"), () -> SmithingTemplateItem.createArmorTrimTemplate((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pickaxetrims", (String)"fracture"), (FeatureFlag[])new FeatureFlag[0]));
        this.itemGroup = this.registryItemGroup.register(ResourceLocation.fromNamespaceAndPath((String)"pickaxetrims", (String)"pickaxe_trims_tab"), () -> CreativeTabRegistry.create((Component)Component.translatable((String)"itemGroup.pickaxetrims"), () -> PickaxeTrim.set(new ItemStack((ItemLike)Items.NETHERITE_PICKAXE), PickaxeTrim.TrimType.EMERALD)));
    }

    public void initialize() {
        this.registryComponentType.register();
        this.registryItem.register();
        this.registryItemGroup.register();
        LootEvent.MODIFY_LOOT_TABLE.register((Object)this);
        TickEvent.SERVER_POST.register((Object)this);
        BlockEvent.BREAK.register((Object)this);
        this.cryingObsidianEffect = new CryingObsidianMultiBreakEffect();
        this.redstoneEffect = new RedstoneVeinMineEffect();
        this.lapisEffect = new LapisGlowEffect();
    }

    public void forEachStackForItemGroup(@NotNull @NotNull Consumer<@NotNull ItemStack> consumer) {
        for (PickaxeTrim.PickaxeType pickaxeType : PickaxeTrim.PickaxeType.VALUES) {
            for (PickaxeTrim.TrimType trimType : PickaxeTrim.TrimType.VALUES) {
                consumer.accept(PickaxeTrim.set(new ItemStack((ItemLike)pickaxeType.getItem()), trimType));
            }
        }
        consumer.accept(new ItemStack((ItemLike)this.getSmithingTemplateItem()));
    }

    private boolean shouldModifyLootTable(ResourceKey<LootTable> key) {
        return this.config.smithingTemplateLootTables.contains(key.location().toString());
    }

    private int getLootTableEmptyEntryWeight() {
        return Math.max(0, 1 - (int)(1.0f / this.config.smithingTemplateLootProbability));
    }

    public void modifyLootTable(ResourceKey<LootTable> key, LootEvent.LootTableModificationContext context, boolean builtin) {
        if (this.shouldModifyLootTable(key)) {
            context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(this.getLootTableEmptyEntryWeight())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)this.getSmithingTemplateItem()).setWeight(1)));
        }
    }

    public void tick(@NotNull MinecraftServer server) {
        this.cryingObsidianEffect.onTickEnd(server);
        this.redstoneEffect.onTickEnd(server);
        this.lapisEffect.onTickEnd(server);
    }

    public EventResult breakBlock(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ServerPlayer player, @Nullable IntValue xp) {
        PickaxeTrim.TrimType trimType = PickaxeTrim.getTrimType(player.getMainHandItem());
        if (trimType != null) {
            switch (trimType) {
                case CRYING_OBSIDIAN: {
                    this.cryingObsidianEffect.onBlockBreak(level, pos, state, player);
                    break;
                }
                case REDSTONE: {
                    this.redstoneEffect.onBlockBreak(level, pos, state, player);
                    break;
                }
                case LAPIS_LAZULI: {
                    this.lapisEffect.onBlockBreak(level, pos, state, player);
                    break;
                }
            }
        }
        return EventResult.pass();
    }
}

