/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared.effect;

import dev.foxgirl.pickaxetrims.shared.OreDetectUtil;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrimsImpl;
import dev.foxgirl.pickaxetrims.shared.effect.AbstractEffect;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class LapisGlowEffect
extends AbstractEffect {
    private final Map<BlockPos, ShulkerEntityState> activeShulkers = new HashMap<BlockPos, ShulkerEntityState>();

    private void highlightBlock(ServerPlayer player, BlockPos pos, Block block) {
        this.activeShulkers.computeIfAbsent(pos, __ -> new ShulkerEntityState(player.serverLevel(), pos, block)).resetTicks();
    }

    private void highlightBlocks(ServerPlayer player, Block expectedBlock) {
        int radius = PickaxeTrimsImpl.getInstance().config.lapisGlowRadius;
        double radiusSquaredDistance = radius * radius;
        BlockPos playerPos = player.blockPosition().above();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block actualBlock;
                    BlockPos blockPos = playerPos.offset(x, y, z);
                    if (!(blockPos.distSqr((Vec3i)playerPos) <= radiusSquaredDistance) || (actualBlock = player.level().getBlockState(blockPos).getBlock()) != expectedBlock) continue;
                    this.highlightBlock(player, blockPos, expectedBlock);
                }
            }
        }
    }

    @Override
    public void onTickEnd(@NotNull MinecraftServer server) {
        this.activeShulkers.values().removeIf(ShulkerEntityState::update);
    }

    @Override
    public void onBlockBreak(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ServerPlayer player) {
        Block block = state.getBlock();
        if (OreDetectUtil.isOreBlock(block)) {
            this.highlightBlocks(player, block);
        }
    }

    private static final class ShulkerEntityState {
        private final ServerLevel world;
        private final BlockPos pos;
        private final Block block;
        private int ticks;
        private final Shulker entity;

        public ShulkerEntityState(ServerLevel world, BlockPos pos, Block block) {
            this.world = world;
            this.pos = pos;
            this.block = block;
            this.resetTicks();
            this.entity = new Shulker(EntityType.SHULKER, (Level)world);
            this.entity.setPosRaw((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            this.entity.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, -1, 0, false, false));
            this.updateEntityFlags();
            world.addFreshEntity((Entity)this.entity);
        }

        private void resetTicks() {
            this.ticks = (int)(20.0f * PickaxeTrimsImpl.getInstance().config.lapisGlowSeconds);
        }

        private void updateEntityFlags() {
            this.entity.setInvulnerable(true);
            this.entity.setNoAi(true);
            this.entity.setInvisible(true);
            this.entity.setGlowingTag(true);
        }

        private boolean update() {
            if (this.ticks-- <= 0 || this.world.getBlockState(this.pos).getBlock() != this.block) {
                this.entity.remove(Entity.RemovalReason.DISCARDED);
                return true;
            }
            this.updateEntityFlags();
            return false;
        }
    }
}

