/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.client;

import com.illusivesoulworks.veinmining.VeinMiningConstants;
import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.ClientServices;
import com.illusivesoulworks.veinmining.common.veinmining.VeinMiningKey;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class VeinMiningClientEvents {
    public static void tick() {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        LocalPlayer player = mc.player;
        if (world != null && player != null && world.getGameTime() % 5L == 0L) {
            boolean needsEnchantment = (Integer)VeinMiningConfig.SERVER.maxBlocksBase.get() == 0;
            VeinMiningConfig.ActivationState activationState = needsEnchantment ? (VeinMiningConfig.ActivationState)((Object)VeinMiningConfig.CLIENT.activationState.get()) : (VeinMiningConfig.ActivationState)((Object)VeinMiningConfig.CLIENT.activationStateWithoutEnchantment.get());
            boolean isKeyDown = VeinMiningKey.get().isDown();
            if (((Boolean)VeinMiningConfig.CLIENT.enableEnchantmentWarnings.get()).booleanValue() && isKeyDown) {
                int level;
                Holder enchantment = player.registryAccess().lookup(Registries.ENCHANTMENT).map(enchantmentRegistryLookup -> enchantmentRegistryLookup.getOrThrow(VeinMiningConstants.ENCHANTMENT)).orElse(null);
                int n = level = enchantment != null ? EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantment, (ItemStack)player.getMainHandItem()) : 0;
                if (activationState != VeinMiningConfig.ActivationState.HOLD_KEY_DOWN) {
                    player.displayClientMessage((Component)Component.translatable((String)"tutorial.veinmining.key.no_configuration"), true);
                } else if (needsEnchantment && level == 0) {
                    player.displayClientMessage((Component)Component.translatable((String)"tutorial.veinmining.key.no_enchantment"), true);
                }
            }
            boolean enabled = activationState == VeinMiningConfig.ActivationState.STANDING ? !player.isCrouching() : (activationState == VeinMiningConfig.ActivationState.CROUCHING ? player.isCrouching() : isKeyDown);
            ClientServices.PLATFORM.sendC2SState(enabled);
        }
    }

    public static void tooltip(ItemStack stack, List<Component> tooltip) {
        boolean needsEnchantment = (Integer)VeinMiningConfig.SERVER.maxBlocksBase.get() == 0;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && needsEnchantment && !(stack.getItem() instanceof EnchantedBookItem) && ((Boolean)VeinMiningConfig.CLIENT.enableEnchantmentTooltips.get()).booleanValue()) {
            int level;
            Holder enchantment = player.registryAccess().lookup(Registries.ENCHANTMENT).map(enchantmentRegistryLookup -> enchantmentRegistryLookup.getOrThrow(VeinMiningConstants.ENCHANTMENT)).orElse(null);
            int n = level = enchantment != null ? EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantment, (ItemStack)stack) : 0;
            if (level > 0) {
                MutableComponent component = VeinMiningClientEvents.getTutorialMessage();
                component.withStyle(ChatFormatting.DARK_AQUA);
                int index = tooltip.size();
                for (int i = 0; i < tooltip.size(); ++i) {
                    MutableComponent mutableComponent;
                    ComponentContents componentContents;
                    Component component1 = tooltip.get(i);
                    if (!(component1 instanceof MutableComponent) || !((componentContents = (mutableComponent = (MutableComponent)component1).getContents()) instanceof TranslatableContents)) continue;
                    TranslatableContents contents1 = (TranslatableContents)componentContents;
                    if (contents1.getKey().startsWith("item.modifiers.")) {
                        index = i;
                        break;
                    }
                    if (!contents1.getKey().startsWith("enchantments.")) continue;
                    index = i;
                    break;
                }
                tooltip.add(index, (Component)component);
                tooltip.add(index + 1, (Component)Component.empty());
            }
        }
    }

    public static MutableComponent getTutorialMessage() {
        MutableComponent component = null;
        switch ((VeinMiningConfig.ActivationState)((Object)VeinMiningConfig.CLIENT.activationState.get())) {
            case STANDING: {
                component = Component.translatable((String)"tutorial.veinmining.enchantment.standing");
                break;
            }
            case CROUCHING: {
                component = Component.translatable((String)"tutorial.veinmining.enchantment.crouching");
                break;
            }
            case HOLD_KEY_DOWN: {
                if (VeinMiningKey.get().isUnbound()) {
                    component = Component.translatable((String)"tutorial.veinmining.enchantment.no_key").withStyle(ChatFormatting.RED);
                    break;
                }
                Component name = VeinMiningKey.get().getTranslatedKeyMessage();
                if (name instanceof MutableComponent) {
                    MutableComponent mutableComponent = (MutableComponent)name;
                    mutableComponent.withStyle(ChatFormatting.YELLOW);
                }
                component = Component.translatable((String)"tutorial.veinmining.enchantment.key", (Object[])new Object[]{name});
            }
        }
        return component;
    }
}

