/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets.blocks.chargingstation;

import com.direwolf20.charginggadgets.blocks.chargingstation.ChargingStationContainer;
import com.direwolf20.charginggadgets.utils.MagicHelpers;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ChargingStationScreen
extends AbstractContainerScreen<ChargingStationContainer> {
    private static final ResourceLocation background = ResourceLocation.fromNamespaceAndPath((String)"charginggadgets", (String)"textures/gui/charging_station.png");
    private final ChargingStationContainer container;

    public ChargingStationScreen(ChargingStationContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.container = container;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (mouseX > this.leftPos + 7 && mouseX < this.leftPos + 7 + 18 && mouseY > this.topPos + 7 && mouseY < this.topPos + 7 + 73) {
            guiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"screen.charginggadgets.energy", (Object[])new Object[]{MagicHelpers.withSuffix(this.container.getEnergy()), MagicHelpers.withSuffix(this.container.getMaxPower())}), this.container.getRemaining() <= 0 ? Component.translatable((String)"screen.charginggadgets.no_fuel") : Component.translatable((String)"screen.charginggadgets.burn_time", (Object[])new Object[]{MagicHelpers.ticksInSeconds(this.container.getRemaining())}))), mouseX, mouseY);
        }
    }

    public void init() {
        super.init();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(background, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int maxHeight = 13;
        if (this.container.getMaxBurn() > 0) {
            int remaining = this.container.getRemaining() * maxHeight / this.container.getMaxBurn();
            guiGraphics.blit(background, this.leftPos + 66, this.topPos + 26 + 13 - remaining, 176, 13 - remaining, 14, remaining + 1);
        }
        int maxEnergy = this.container.getMaxPower();
        int height = 70;
        if (maxEnergy > 0) {
            int remaining = this.container.getEnergy() * height / maxEnergy;
            guiGraphics.blit(background, this.leftPos + 8, this.topPos + 78 - remaining, 176, 84 - remaining, 16, remaining + 1);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, I18n.get((String)"block.charginggadgets.charging_station", (Object[])new Object[0]), 55, 8, Color.DARK_GRAY.getRGB(), false);
    }
}

