/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.feature.stalled_chunk_load_detection;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.embeddedt.modernfix.ModernFix;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerChunkCache.class}, priority=1100)
public abstract class ServerChunkCacheMixin {
    @Shadow
    @Final
    private Thread mainThread;
    @Shadow
    @Final
    public ServerLevel level;
    @Shadow
    @Final
    private ServerChunkCache.MainThreadExecutor mainThreadProcessor;
    private final boolean debugDeadServerAccess = Boolean.getBoolean("modernfix.debugBadChunkloading");

    @Shadow
    protected abstract CompletableFuture<ChunkResult<ChunkAccess>> getChunkFutureMainThread(int var1, int var2, ChunkStatus var3, boolean var4);

    @Inject(method={"getChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private void bailIfServerDead(int chunkX, int chunkZ, ChunkStatus requiredStatus, boolean load, CallbackInfoReturnable<ChunkAccess> cir) {
        CompletableFuture future;
        if (!this.level.getServer().isRunning() && !this.mainThread.isAlive()) {
            ModernFix.LOGGER.fatal("A mod is accessing chunks from a stopped server (this will also cause memory leaks)");
            if (this.debugDeadServerAccess) {
                new Exception().printStackTrace();
            }
            Holder.Reference plains = this.level.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Biomes.PLAINS);
            cir.setReturnValue((Object)new EmptyLevelChunk((Level)this.level, new ChunkPos(chunkX, chunkZ), (Holder)plains));
        } else if (Thread.currentThread() != this.mainThread && !(future = CompletableFuture.supplyAsync(() -> this.getChunkFutureMainThread(chunkX, chunkZ, requiredStatus, false), (Executor)this.mainThreadProcessor).join()).isDone()) {
            ChunkResult resultingChunk = null;
            try {
                resultingChunk = (ChunkResult)future.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            if (resultingChunk != null && resultingChunk.isSuccess()) {
                cir.setReturnValue((Object)((ChunkAccess)resultingChunk.orElse(null)));
                return;
            }
            if (this.debugDeadServerAccess) {
                ModernFix.LOGGER.warn("Async loading of a chunk was requested, this might not be desirable", (Throwable)new Exception());
            }
            try {
                resultingChunk = (ChunkResult)future.get(10L, TimeUnit.SECONDS);
                if (resultingChunk.isSuccess()) {
                    cir.setReturnValue((Object)((ChunkAccess)resultingChunk.orElse(null)));
                    return;
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                ModernFix.LOGGER.error("Async chunk load took way too long, this needs to be reported to the appropriate mod.", (Throwable)e);
            }
        }
    }
}

