/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.new_slab_variants.core.common.registry;

import forge.com.cursee.new_slab_variants.core.common.registry.ModBlockEntityTypesForge;
import forge.com.cursee.new_slab_variants.core.common.registry.ModBlocksForge;
import forge.com.cursee.new_slab_variants.core.common.registry.ModEntityTypesForge;
import forge.com.cursee.new_slab_variants.core.common.registry.ModItemsForge;
import forge.com.cursee.new_slab_variants.core.common.registry.ModTabsForge;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RegistryForge {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"new_slab_variants");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"new_slab_variants");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)BuiltInRegistries.f_279662_.m_123023_(), (String)"new_slab_variants");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"new_slab_variants");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"new_slab_variants");

    public static void register(IEventBus modEventBus) {
        ModBlocksForge.register();
        ModItemsForge.register();
        ModTabsForge.register();
        ModBlockEntityTypesForge.register();
        ModEntityTypesForge.register();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        ModTabsForge.slabItemsToAdd.addAll(ITEMS.getEntries());
        TABS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        ENTITY_TYPES.register(modEventBus);
    }

    protected static <T extends Block> RegistryObject<T> registerBlock(String blockID, Supplier<T> blockSupplier) {
        return BLOCKS.register(blockID, blockSupplier);
    }

    protected static <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    protected static <T extends Block> RegistryObject<T> registerBlockAndBlockItem(String name, Supplier<T> block) {
        RegistryObject toReturn = RegistryForge.registerBlock(name, block);
        RegistryForge.registerItem(name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    protected static <T extends CreativeModeTab> RegistryObject<T> registerCreativeModeTab(String tabID, Supplier<T> tab) {
        return TABS.register(tabID, tab);
    }

    protected static <T extends BlockEntityType<?>> RegistryObject<T> registerBlockEntityType(String entityTypeID, Supplier<T> entityType) {
        return BLOCK_ENTITY_TYPES.register(entityTypeID, entityType);
    }

    protected static <T extends EntityType<?>> RegistryObject<T> registerEntityType(String entityTypeID, Supplier<T> entityType) {
        return ENTITY_TYPES.register(entityTypeID, entityType);
    }
}

