/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.server.handaction;

import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.handaction.HandActionCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.handaction.HandActionSPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static void handleData(HandActionSPacket data, IPayloadContext context) {
        ServerPayloadHandler.playerChanged(data, context.player());
        context.enqueueWork(() -> ServerPayloadHandler.playerChanged(data, context.player())).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weaponmaster_ydm.networking.failed.server", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void playerChanged(HandActionSPacket packetdata, Player sender) {
        PlayerData data;
        assert (sender.level() != null);
        if (!sender.level().isClientSide() && (data = ((IPlayerData)sender).getPlayerData()) != null) {
            if (packetdata.value()) {
                data.lastMainhandHit = 1;
            } else {
                data.lastOffhandHit = 1;
            }
            for (Player sp : sender.level().players()) {
                Networking.sendToClient(new HandActionCPacket(packetdata.value(), sender.getStringUUID()), (ServerPlayer)sp);
            }
        }
    }
}

