/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.server.hidetick;

import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.hidetick.HideTickCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.hidetick.HideTickSPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static void handleData(HideTickSPacket data, IPayloadContext context) {
        ServerPayloadHandler.playerChanged(data, context.player());
        context.enqueueWork(() -> ServerPayloadHandler.playerChanged(data, context.player())).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weaponmaster_ydm.networking.failed.server", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void playerChanged(HideTickSPacket packetdata, Player sender) {
        PlayerData data;
        assert (sender.level() != null);
        if (!sender.level().isClientSide() && (data = ((IPlayerData)sender).getPlayerData()) != null) {
            data.hideTick = packetdata.value();
            for (Player sp : sender.level().players()) {
                Networking.sendToClient(new HideTickCPacket(packetdata.value(), false, sender.getStringUUID()), (ServerPlayer)sp);
            }
        }
    }
}

