/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonHandler;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

public class CommandGetSeason {
    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"get").executes(ctx -> {
            ServerLevel world = ((CommandSourceStack)ctx.getSource()).getLevel();
            return CommandGetSeason.getSeason((CommandSourceStack)ctx.getSource(), (Level)world);
        });
    }

    private static int getSeason(CommandSourceStack cs, Level world) {
        SeasonSavedData seasonData = SeasonHandler.getSeasonSavedData(world);
        SeasonTime time = new SeasonTime(seasonData.seasonCycleTicks);
        int subSeasonDuration = ModConfig.seasons.subSeasonDuration;
        cs.sendSuccess(() -> Component.translatable((String)"commands.sereneseasons.getseason.success", (Object[])new Object[]{Component.translatable((String)("desc.sereneseasons." + time.getSubSeason().toString().toLowerCase(Locale.ROOT))), time.getDay() % subSeasonDuration + 1, subSeasonDuration, time.getSeasonCycleTicks() % time.getDayDuration(), time.getDayDuration()}), true);
        return 1;
    }
}

