/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.time_on_display.core;

import forge.com.cursee.time_on_display.TimeOnDisplayForge;
import forge.com.cursee.time_on_display.core.TimeOnDisplayConfig;
import java.time.LocalTime;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;

public class TimeOnDisplayOverlayForge
implements LayeredDraw.Layer {
    public static final ResourceLocation DEFAULT_CLOCK = ResourceLocation.fromNamespaceAndPath((String)"time_on_display", (String)"textures/display/default_clock.png");
    public static final ResourceLocation ALTERNATE_CLOCK_1 = ResourceLocation.fromNamespaceAndPath((String)"time_on_display", (String)"textures/display/alternate_clock_1.png");
    public static final ResourceLocation ALTERNATE_CLOCK_2 = ResourceLocation.fromNamespaceAndPath((String)"time_on_display", (String)"textures/display/alternate_clock_2.png");

    public void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        boolean displayEnabled = TimeOnDisplayConfig.displayEnabled;
        boolean displayOnlySystemTime = TimeOnDisplayConfig.displayOnlySystemTime;
        boolean displayClockIcons = TimeOnDisplayConfig.displayClockIcons;
        boolean display24Hour = TimeOnDisplayConfig.display24Hour;
        String displayLocation = TimeOnDisplayConfig.displayLocation;
        String displaySystemTimeIcon = TimeOnDisplayConfig.displaySystemTimeIcon;
        boolean lowestX = false;
        boolean lowestY = false;
        int highestX = graphics.guiWidth();
        int highestY = graphics.guiHeight();
        if (displayEnabled && TimeOnDisplayForge.displayToggle) {
            int gameClockIconX = 0;
            int gameClockIconY = 0;
            int gameClockTextX = 0;
            int gameClockTextY = 0;
            int systemClockIconX = 0;
            int systemClockIconY = 0;
            int systemClockTextX = 0;
            int systemClockTextY = 0;
            Object time = String.valueOf(LocalTime.now()).substring(0, 5);
            if (!display24Hour) {
                Integer hoursFromTime = Integer.valueOf(((String)time).substring(0, 2));
                if (hoursFromTime > 12) {
                    hoursFromTime = hoursFromTime - 12;
                }
                time = ((String)time).substring(2, 5);
                time = String.valueOf(hoursFromTime) + (String)time;
            }
            String minecraft_time = "";
            if (Minecraft.getInstance().level != null) {
                ClientLevel level = Minecraft.getInstance().level;
                minecraft_time = String.valueOf(level.getDayTime());
            } else {
                minecraft_time = "0";
            }
            switch (displayLocation) {
                case "lower-left": {
                    systemClockIconX = 0;
                    systemClockIconY = highestY - 32;
                    systemClockTextX = 18;
                    systemClockTextY = highestY - 32 + 5;
                    gameClockIconX = 0;
                    gameClockIconY = highestY - 16;
                    gameClockTextX = 18;
                    gameClockTextY = highestY - 16 + 5;
                    break;
                }
                case "upper-left": {
                    systemClockIconX = 0;
                    systemClockIconY = 0;
                    systemClockTextX = 18;
                    systemClockTextY = 5;
                    gameClockIconX = 0;
                    gameClockIconY = 16;
                    gameClockTextX = 18;
                    gameClockTextY = 21;
                    break;
                }
                case "upper-middle": {
                    systemClockIconX = highestX / 2;
                    systemClockIconY = 0;
                    systemClockTextX = highestX / 2;
                    systemClockTextY = 0;
                    gameClockIconX = highestX / 2;
                    gameClockIconY = 0;
                    gameClockTextX = highestX / 2;
                    gameClockTextY = 0;
                    systemClockIconX -= 32;
                    systemClockIconY += 0;
                    gameClockIconX -= 32;
                    gameClockIconY += 16;
                    systemClockTextX -= 14;
                    systemClockTextY += 5;
                    gameClockTextX -= 14;
                    gameClockTextY += 21;
                    break;
                }
                case "upper-right": {
                    systemClockIconX = highestX - 16;
                    systemClockIconY = 0;
                    systemClockTextX = highestX - 32 - 10;
                    systemClockTextY = 5;
                    gameClockIconX = highestX - 16;
                    gameClockIconY = 16;
                    gameClockTextX = highestX - 32 - 10;
                    gameClockTextY = 21;
                    break;
                }
                case "lower-right": {
                    systemClockIconX = highestX - 16;
                    systemClockIconY = highestY - 32;
                    systemClockTextX = highestX - 32 - 10;
                    systemClockTextY = highestY - 32 + 5;
                    gameClockIconX = highestX - 16;
                    gameClockIconY = highestY - 16;
                    gameClockTextX = highestX - 32 - 10;
                    gameClockTextY = highestY - 16 + 5;
                    break;
                }
                default: {
                    systemClockIconX -= 9999;
                    systemClockIconY -= 9999;
                    systemClockTextX -= 9999;
                    systemClockTextY -= 9999;
                    gameClockIconX -= 9999;
                    gameClockIconY -= 9999;
                    gameClockTextX -= 9999;
                    gameClockTextY -= 9999;
                }
            }
            if (displayOnlySystemTime) {
                gameClockIconX -= 9999;
                gameClockTextX -= 9999;
                switch (displayLocation) {
                    case "lower-left": {
                        systemClockIconY += 16;
                        systemClockTextY += 16;
                        break;
                    }
                    case "lower-right": {
                        systemClockIconY += 16;
                        systemClockTextY += 16;
                    }
                }
            }
            if (!displayClockIcons) {
                systemClockIconX -= 9999;
                gameClockIconX -= 9999;
                switch (displayLocation) {
                    case "lower-left": {
                        systemClockTextX -= 16;
                        gameClockTextX -= 16;
                        break;
                    }
                    case "upper-left": {
                        systemClockTextX -= 16;
                        gameClockTextX -= 16;
                        break;
                    }
                    case "upper-middle": {
                        systemClockTextX -= 16;
                        gameClockTextX -= 16;
                        break;
                    }
                    case "upper-right": {
                        systemClockTextX += 16;
                        gameClockTextX += 16;
                        break;
                    }
                    case "lower-right": {
                        systemClockTextX += 16;
                        gameClockTextX += 16;
                    }
                }
            }
            switch (displaySystemTimeIcon) {
                case "1": {
                    graphics.blit(ALTERNATE_CLOCK_1, systemClockIconX, systemClockIconY, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                    break;
                }
                case "2": {
                    graphics.blit(ALTERNATE_CLOCK_2, systemClockIconX, systemClockIconY, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                    break;
                }
                default: {
                    graphics.blit(DEFAULT_CLOCK, systemClockIconX, systemClockIconY, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                }
            }
            graphics.renderItem(Items.CLOCK.getDefaultInstance(), gameClockIconX, gameClockIconY);
            graphics.drawString(Minecraft.getInstance().font, (String)time, systemClockTextX, systemClockTextY, -1, false);
            graphics.drawString(Minecraft.getInstance().font, minecraft_time, gameClockTextX, gameClockTextY, -1, false);
        }
    }
}

