/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.config;

import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.base.Preconditions;
import com.mrcrayfish.framework.api.config.BoolProperty;
import com.mrcrayfish.framework.api.config.DoubleProperty;
import com.mrcrayfish.framework.api.config.EnumProperty;
import com.mrcrayfish.framework.api.config.IntProperty;
import com.mrcrayfish.framework.api.config.ListProperty;
import com.mrcrayfish.framework.api.config.LongProperty;
import com.mrcrayfish.framework.api.config.StringProperty;
import com.mrcrayfish.framework.api.config.validate.Validator;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;

public abstract sealed class AbstractProperty<T>
implements FrameworkConfigManager.IMapEntry
permits BoolProperty, DoubleProperty, EnumProperty, IntProperty, ListProperty, LongProperty, StringProperty {
    protected final T defaultValue;
    protected final BiFunction<UnmodifiableConfig, List<String>, T> getFunction;
    protected final Validator<T> validator;
    private T value;
    private boolean cached;
    protected FrameworkConfigManager.ValueProxy proxy;
    protected FrameworkConfigManager.PropertyData data;

    AbstractProperty(T defaultValue) {
        this(defaultValue, (Validator)null);
    }

    AbstractProperty(T defaultValue, Validator<T> validator) {
        this(defaultValue, (config, path) -> config.getOrElse(path, defaultValue), validator);
    }

    AbstractProperty(T defaultValue, BiFunction<UnmodifiableConfig, List<String>, T> getFunction) {
        this(defaultValue, getFunction, null);
    }

    AbstractProperty(T defaultValue, BiFunction<UnmodifiableConfig, List<String>, T> getFunction, Validator<T> validator) {
        this.defaultValue = defaultValue;
        this.getFunction = getFunction;
        this.validator = validator;
    }

    public abstract void defineSpec(ConfigSpec var1);

    public abstract boolean isValid(T var1);

    @Nullable
    public Validator<T> getValidator() {
        return this.validator;
    }

    private boolean isLinked() {
        return this.proxy != null && this.proxy.isLinked();
    }

    public T get() {
        if (!this.isLinked()) {
            throw new IllegalStateException("Config property is not linked yet");
        }
        if (!this.cached) {
            this.value = this.proxy.get(this.getFunction);
            this.cached = true;
        }
        return this.value;
    }

    public void set(T value) {
        if (!this.isLinked()) {
            throw new IllegalStateException("Config property is not linked yet");
        }
        if (this.proxy.isWritable()) {
            this.value = value;
            this.proxy.set(value);
        }
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void restoreDefault() {
        this.set(this.getDefaultValue());
    }

    public boolean isDefault() {
        return Objects.equals(this.get(), this.getDefaultValue());
    }

    public void invalidateCache() {
        this.cached = false;
    }

    public String getName() {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        return this.data.getName();
    }

    public List<String> getPath() {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        return this.data.getPath();
    }

    public String getTranslationKey() {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        return this.data.getTranslationKey();
    }

    public String getComment() {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        return this.data.getComment();
    }

    public boolean requiresWorldRestart() {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        return this.data.requiresWorldRestart();
    }

    public boolean requiresGameRestart() {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        return this.data.requiresGameRestart();
    }

    public final void updateProxy(FrameworkConfigManager.ValueProxy proxy) {
        Preconditions.checkNotNull((Object)proxy, (Object)"Tried to update config property with a null value proxy");
        this.proxy = proxy;
        this.invalidateCache();
    }

    public final void initProperty(FrameworkConfigManager.PropertyData data) {
        Preconditions.checkNotNull((Object)data, (Object)"Tried to update path with a null path object");
        if (this.data == null) {
            this.data = data;
        }
    }

    public String getAllowedValuesString() {
        String hint;
        if (this.validator != null && !(hint = this.validator.getCommentHint()).isBlank()) {
            return hint;
        }
        return "";
    }
}

